/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.core;

import io.intino.amidas.accessor.core.Facet;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Work {
    private String name;
    private String label;
    private String description;
    private String thread;
    private String originator;
    private Priority priority;
    private Map<String, Facet> facets = new HashMap<String, Facet>();
    private List<Trace> traces = new ArrayList<Trace>();
    private List<String> tags = new ArrayList<String>();

    public Work(String originator, String label) {
        this.originator = originator;
        this.label = label;
        this.priority = Priority.Normal;
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String thread() {
        return this.thread;
    }

    public void thread(String thread) {
        this.thread = thread;
    }

    public String originator() {
        return this.originator;
    }

    public void originator(String originator) {
        this.originator = originator;
    }

    public Priority priority() {
        return this.priority;
    }

    public void priority(Priority priority) {
        this.priority = priority;
    }

    public AllocatedWork asAllocated() {
        return resource -> this.facet("allocated").set("to", resource);
    }

    public OfferedWork asOffered() {
        return new OfferedWork(){

            @Override
            public OfferedWork toCapability(String capability) {
                Work.this.facet("offered").set("capability", capability);
                return this;
            }

            @Override
            public OfferedWork toGroup(String group) {
                Work.this.facet("offered").set("group", group);
                return this;
            }

            @Override
            public OfferedWork with(String ... requirements) {
                List<String> withList = this.withList();
                Arrays.stream(requirements).forEach(withList::add);
                Work.this.facet("offered").set("with", withList);
                return this;
            }

            @Override
            public OfferedWork withSkills(String ... skills) {
                return this.with(skills);
            }

            @Override
            public OfferedWork withLocations(String ... locations) {
                return this.with(locations);
            }

            @Override
            public OfferedWork withAuthorizations(String ... authorizations) {
                return this.with(authorizations);
            }

            private List<String> withList() {
                Map<String, List<String>> parameters = Work.this.facet("offered").parameters();
                return parameters.containsKey("with") ? parameters.get("with") : new ArrayList();
            }
        };
    }

    public AssignmentWork asAssignment() {
        return new AssignmentWork(){

            @Override
            public AssignmentWork toCapability(String capability) {
                Work.this.facet("assignment").set("capability", capability);
                return this;
            }
        };
    }

    public List<Facet> facets() {
        return new ArrayList<Facet>(this.facets.values());
    }

    public List<Trace> traces() {
        return this.traces;
    }

    public void add(Trace ... traces) {
        for (int i = 0; i < traces.length; ++i) {
            this.traces.add(traces[i]);
        }
    }

    public List<String> tags() {
        return this.tags;
    }

    public void add(String ... tags) {
        for (int i = 0; i < tags.length; ++i) {
            this.tags.add(tags[i]);
        }
    }

    protected Facet facet(String name) {
        if (!this.facets.containsKey(name)) {
            this.facets.put(name, new Facet(name));
        }
        return this.facets.get(name);
    }

    public static interface Trace {
        public LocalDateTime createDate();

        public String description();

        public Map<String, InputStream> attachments();
    }

    public static interface Frame {
        public String description();

        public Map<String, InputStream> attachments();
    }

    public static interface AssignmentWork {
        public AssignmentWork toCapability(String var1);
    }

    public static interface OfferedWork {
        public OfferedWork toCapability(String var1);

        public OfferedWork toGroup(String var1);

        public OfferedWork with(String ... var1);

        public OfferedWork withSkills(String ... var1);

        public OfferedWork withLocations(String ... var1);

        public OfferedWork withAuthorizations(String ... var1);
    }

    public static interface AllocatedWork {
        public void to(String var1);
    }

    public static enum Priority {
        High,
        Normal,
        Low;

    }
}

