/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.core;

import io.intino.alexandria.zif.Zif;
import io.intino.amidas.accessor.core.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PropertyChecker {
    private final Property property;
    private final List<Checker> checkers;

    public PropertyChecker(Property property) {
        this.property = property;
        this.checkers = this.add(this.identifierChecker(), this.grammarChecker());
    }

    private List<Checker> add(Checker ... checkers) {
        return Arrays.stream(checkers).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public PropertyChecker set(Zif zif) {
        this.checkers.add(this.uniqueChecker(zif));
        return this;
    }

    private Checker grammarChecker() {
        if (this.property.grammar() == null) {
            return null;
        }
        return new Grammar(this.property.grammar())::parse;
    }

    private Checker uniqueChecker(Zif zif) {
        if (!this.property.isIdentifier()) {
            return null;
        }
        return v -> zif.search("id/", v).size() >= 1 ? "Identifier already exists" : null;
    }

    private Checker identifierChecker() {
        if (!this.property.isIdentifier()) {
            return null;
        }
        return v -> v.contains(" ") ? "Identifier can not contain blank spaces" : null;
    }

    public String check(String value) {
        for (Checker checker : this.checkers) {
            String check = checker.check(value);
            if (check == null) continue;
            return check;
        }
        return null;
    }

    private static interface Checker {
        public String check(String var1);
    }

    private static enum Type {
        invalidToken,
        expectedToken;

    }

    private static enum Token {
        constant,
        date,
        email;

    }

    public static class Error {
        final Token token;
        final Type type;
        final int position;

        Error(Type type, Token token, int position) {
            this.token = token;
            this.type = type;
            this.position = position;
        }
    }

    public static class Grammar {
        private static final String Expected = "Expected ";
        private final List<String[]> options;
        private static final Pattern email = Pattern.compile("^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$");
        private static final Pattern date = Pattern.compile("^((19|2[0-9])[0-9]{2})(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])$");

        public Grammar(String definition) {
            this.options = this.load(definition);
        }

        public String parse(String text) {
            return this.parse(text, text.contains("\n"));
        }

        String parse(String text, boolean multiple) {
            return multiple ? this.parseMultiple(text) : this.parseSingle(text);
        }

        private String parseSingle(String text) {
            return this.parse(this.tokenize(text));
        }

        private String parseMultiple(String text) {
            String[] sentences = text.split("\n");
            for (int i = 0; i < sentences.length; ++i) {
                String result = this.parse(this.tokenize(sentences[i]));
                if (result == null) continue;
                return sentences.length > 1 ? result + " in line " + (i + 1) : result;
            }
            return null;
        }

        private String parse(String[] value) {
            ArrayList<Error> errors = new ArrayList<Error>();
            for (String[] option : this.options) {
                Error error = this.match(value, option);
                if (error == null) {
                    return null;
                }
                errors.add(error);
            }
            if (this.isAnyExpectedToken(errors)) {
                return Expected + this.expected(errors);
            }
            Integer index = this.indexOfMax(errors);
            return "'" + value[index] + "' is an invalid " + (Object)((Object)((Error)errors.get((int)index.intValue())).token);
        }

        private String expected(List<Error> errors) {
            StringJoiner joiner = new StringJoiner(" | ");
            for (int i = 0; i < this.options.size(); ++i) {
                Error error = errors.get(i);
                if (error.type == Type.invalidToken) continue;
                String s = this.options.get(i)[error.position];
                joiner.add(s);
            }
            return joiner.toString();
        }

        private boolean isAnyExpectedToken(List<Error> errors) {
            return errors.stream().anyMatch(s -> s.type == Type.expectedToken);
        }

        private Integer indexOfMax(List<Error> errors) {
            return errors.stream().filter(e -> e.type == Type.invalidToken).map(e -> e.position).max(Comparator.comparingInt(o -> o)).orElse(0);
        }

        private Error match(String[] value, String[] expected) {
            for (int i = 0; i < value.length && i < expected.length; ++i) {
                Error error = this.match(i, value[i], expected[i]);
                if (error == null) continue;
                return error;
            }
            if (value.length == expected.length) {
                return null;
            }
            return value.length < expected.length ? new Error(Type.expectedToken, this.tokenIn(expected[value.length]), value.length) : new Error(Type.invalidToken, Token.constant, value.length - 1);
        }

        private Error match(int position, String value, String expected) {
            Token token = this.tokenIn(expected);
            Pattern pattern = this.patternOf(token);
            boolean match = pattern == null ? value.equalsIgnoreCase(expected) : pattern.matcher(value).matches();
            return match ? null : new Error(Type.invalidToken, token, position);
        }

        private Token tokenIn(String expected) {
            return this.isVariable(expected) ? Token.valueOf(expected.substring(1).toLowerCase()) : Token.constant;
        }

        private Pattern patternOf(Token token) {
            return token == Token.date ? date : (token == Token.email ? email : null);
        }

        private boolean isVariable(String token) {
            return token.charAt(0) == '#';
        }

        private List<String[]> load(String definition) {
            ArrayList<String[]> list = new ArrayList<String[]>();
            for (String option : definition.split("\\|")) {
                list.add(this.tokenize(option));
            }
            return list;
        }

        private String[] tokenize(String option) {
            return (String[])Arrays.stream(option.split(" ")).filter(s -> !s.isEmpty()).toArray(String[]::new);
        }

        public boolean isEmpty() {
            return this.options.size() == 0;
        }
    }
}

