/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor;

import io.intino.alexandria.zif.Zif;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class Federation {
    private final File file;
    private final Zif zif;

    public Federation(File file) throws IOException {
        this.file = file;
        this.zif = new Zif(file);
    }

    public Identity createIdentity() {
        return new Identity();
    }

    public Identity get(String identity) {
        return this.map(this.zif.get(this.idOf(identity)));
    }

    private String idOf(String identity) {
        return this.zif.search("id/", identity).first();
    }

    public List<Identity> search(String text) {
        return this.search("id/", text);
    }

    public List<Identity> search(String property, String text) {
        return this.asList(this.zif.search(a -> a.property().startsWith(property) && a.value().contains(text)));
    }

    private List<Identity> asList(Zif.Search search) {
        return search.stream().map((? super T id) -> this.identity((String)id, this.zif.get(id))).collect(Collectors.toList());
    }

    private Identity identity(String id, List<Zif.Assertion> assertions) {
        return new Identity(id, this.statementsOf(assertions));
    }

    public Builder build(Identity identity) {
        return new Builder(identity);
    }

    private Identity map(List<Zif.Assertion> assertions) {
        return assertions.size() > 0 ? new Identity(this.idOf(assertions), this.statementsOf(assertions)) : new Identity();
    }

    private String idOf(List<Zif.Assertion> assertions) {
        return assertions.get(0).id();
    }

    private List<Statement> statementsOf(List<Zif.Assertion> assertions) {
        HashMap<String, Statement> collect = new HashMap<String, Statement>();
        for (Zif.Assertion a : assertions) {
            collect.put(a.property(), new Statement(a.property(), a.value()));
        }
        return new ArrayList<Statement>(collect.values());
    }

    private static class Parser {
        private String[] tokens;

        Parser(String tokens) {
            this.tokens = tokens.split(" ");
        }

        String after(String token, String defaultValue) {
            for (int i = 0; i < this.tokens.length - 1; ++i) {
                if (!this.tokens[i].equals(token)) continue;
                return this.tokens[i + 1];
            }
            return defaultValue;
        }
    }

    public class Builder {
        private final Identity identity;

        Builder(Identity identity) {
            this.identity = identity;
        }

        public Builder append(Definition definition) {
            return this.append(new Statement(definition.property(), definition.value()));
        }

        public Builder append(Statement statement) {
            Federation.this.zif.append(new Zif.Assertion(Instant.now(), this.identity.id(), statement.property(), statement.value()));
            return this;
        }

        public void save() throws IOException {
            Federation.this.zif.save(Federation.this.file);
        }
    }

    public class Identity
    implements Iterable<Statement> {
        private final String id;
        private List<Statement> statements;

        Identity() {
            this(UUID.randomUUID().toString(), new ArrayList<Statement>());
        }

        Identity(String id, List<Statement> statements) {
            this.id = id;
            this.statements = statements;
        }

        public boolean isEmpty() {
            return this.statements.isEmpty();
        }

        public String id() {
            return this.id;
        }

        public Statement get(String property) {
            return this.statements.stream().filter(s -> s.has(property)).findFirst().orElse(null);
        }

        public List<Statement> search(String property) {
            return this.statements.stream().filter(s -> s.has(property)).collect(Collectors.toList());
        }

        public Id getId(String name) {
            return new Id(this.get("id/" + name));
        }

        public Feature getFeature(String name) {
            return new Feature(this.get("feature/" + name));
        }

        public Credential getCredential(String name) {
            return new Credential(this.get("credential/" + name));
        }

        public Role getRole(String name) {
            return new Role(this.get("role/" + name));
        }

        public List<Id> ids() {
            return this.ids("");
        }

        public List<Id> ids(String type) {
            return this.statements.stream().filter(s -> s.has("id/" + type)).map(Id::new).collect(Collectors.toList());
        }

        public List<Feature> features() {
            return this.features("");
        }

        public List<Feature> features(String type) {
            return this.statements.stream().filter(s -> s.has("feature/" + type)).map(Feature::new).collect(Collectors.toList());
        }

        public List<Credential> credentials() {
            return this.credentials("");
        }

        public List<Credential> credentials(String type) {
            return this.statements.stream().filter(s -> s.has("credential/" + type)).map(Credential::new).collect(Collectors.toList());
        }

        public List<Role> roles() {
            return this.roles("");
        }

        public List<Role> roles(String type) {
            return this.statements.stream().filter(s -> s.has("role/" + type)).map(Role::new).collect(Collectors.toList());
        }

        public Identity append(Definition definition) {
            Statement statement = new Statement(definition.property(), definition.value());
            this.statementOf(statement.property()).ifPresent(s -> this.statements.remove(s));
            this.statements.add(statement);
            Federation.this.build(this).append(statement);
            return this;
        }

        private Optional<Statement> statementOf(String property) {
            return this.statements.stream().filter(s -> s.has(property)).findFirst();
        }

        public void save() throws IOException {
            Federation.this.build(this).save();
        }

        public Federation federation() {
            return Federation.this;
        }

        @Override
        public Iterator<Statement> iterator() {
            return this.statements.iterator();
        }

        public String toString() {
            return "[" + this.id + "]\n" + this.statements.stream().map(Object::toString).collect(Collectors.joining("\n"));
        }

        public boolean equals(Object object) {
            return this == object || this.isIdentity(object) && this.id.equals(((Identity)object).id);
        }

        private boolean isIdentity(Object object) {
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class Role
    implements Definition {
        private final String name;
        private final String from;
        private final String until;

        public Role(Statement statement) {
            this.name = statement.property.replace("role/", "");
            this.from = new Parser(statement.value).after("from", "00000000");
            this.until = new Parser(statement.value).after("until", "99999999");
        }

        public Role(String name) {
            this.name = name;
            this.from = "00000000";
            this.until = "99999999";
        }

        public Role(String name, String from) {
            this.name = name;
            this.from = from;
            this.until = "99999999";
        }

        public Role(String name, String from, String until) {
            this.name = name;
            this.from = from;
            this.until = until;
        }

        public String name() {
            return this.name;
        }

        public String from() {
            return this.from;
        }

        public String until() {
            return this.until;
        }

        public boolean isEnabled(Instant instant) {
            return this.isEnabled(instant.toString().replaceAll("[-TZ:\\.]", ""));
        }

        private boolean isEnabled(String instant) {
            return instant.compareTo(this.from) >= 0 && this.until.compareTo(instant) >= 0;
        }

        public String toString() {
            return this.name + " " + this.value();
        }

        @Override
        public String property() {
            return "role/" + this.name;
        }

        @Override
        public String value() {
            return "from " + this.from + " until " + this.until;
        }
    }

    public static class Credential
    implements Definition {
        private final String name;
        private final String value;

        public Credential(Statement statement) {
            this.name = statement.property.replace("credential/", "");
            this.value = statement.value;
        }

        public Credential(String name) {
            this(name, "?");
        }

        public Credential(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String property() {
            return "credential/" + this.name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        public boolean isEnabled() {
            return !this.value.startsWith("?");
        }

        public String toString() {
            return this.name + " " + this.value;
        }
    }

    public static class Feature
    implements Definition {
        private final String name;
        private final String value;

        public Feature(Statement statement) {
            this.name = statement.property.replace("feature/", "");
            this.value = statement.value;
        }

        public Feature(String name) {
            this(name, "?");
        }

        public Feature(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String property() {
            return "feature/" + this.name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            return this.name + " " + this.value;
        }
    }

    public static class Id
    implements Definition {
        private final String name;
        private final String value;

        public Id(Statement statement) {
            this.name = statement.property.replace("id/", "");
            this.value = statement.value;
        }

        public Id(String name) {
            this(name, "?");
        }

        public Id(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        @Override
        public String property() {
            return "id/" + this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            return this.name + " " + this.value;
        }
    }

    static interface Definition {
        public String property();

        public String value();
    }

    public static class Statement {
        private final String property;
        private final String value;

        public Statement(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String property() {
            return this.property;
        }

        public String value() {
            return this.value;
        }

        boolean has(String property) {
            return this.property.startsWith(property);
        }

        public String toString() {
            return this.property + '=' + this.value;
        }

        public boolean equals(Object object) {
            return this == object || this.isSameClass(object) && Objects.equals(this.value, ((Statement)object).value);
        }

        private boolean isSameClass(Object object) {
            return object != null && this.getClass() == object.getClass();
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

