/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zit;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.resourcecleaner.DisposableResource;
import io.intino.alexandria.zit.Zit;
import io.intino.alexandria.zit.ZitStream;
import io.intino.alexandria.zit.model.Data;
import io.intino.alexandria.zit.model.Period;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ZitWriter
implements AutoCloseable {
    private final Writer writer;
    private final DisposableResource resource;
    private Period period;
    private Instant nextTs;

    public ZitWriter(File file) throws IOException {
        file.getParentFile().mkdirs();
        if (file.exists() && file.length() > 0L) {
            this.loadHeader(file);
        }
        this.writer = new OutputStreamWriter(Zit.compressing(new BufferedOutputStream(new FileOutputStream(file, true))));
        this.resource = DisposableResource.whenDestroyed((Object)this).thenClose((Object)this.writer);
    }

    public ZitWriter(OutputStream stream) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(Zit.compressing(stream)));
        this.resource = DisposableResource.whenDestroyed((Object)this).thenClose((Object)this.writer);
    }

    public ZitWriter(File file, String id, String sensor, Period period, String[] sensorModel) throws IOException {
        this.period = period;
        boolean exists = file.exists();
        file.getParentFile().mkdirs();
        this.writer = new OutputStreamWriter(Zit.compressing(new BufferedOutputStream(new FileOutputStream(file))));
        if (!exists || file.length() == 0L) {
            this.writeLine("@id " + id);
            this.writeLine("@sensor " + sensor);
            this.writeLine("@period " + period.toString());
            this.put(sensorModel);
        }
        this.resource = DisposableResource.whenDestroyed((Object)this).thenClose((Object)this.writer);
    }

    public void put(String[] sensorModel) {
        this.writeLine("@measurements " + String.join((CharSequence)"\u0000", sensorModel).stripTrailing());
    }

    private void loadHeader(File file) throws IOException {
        try (ZitStream stream = ZitStream.of(file);){
            Data data = stream.reduce((first, second) -> second).orElse(null);
            if (data != null) {
                this.period = stream.period();
                this.nextTs = this.period.next(data.ts());
            }
        }
    }

    public void put(Instant instant) {
        this.writeLine("@instant " + instant.toString());
        this.nextTs = instant;
    }

    public void put(Instant instant, double[] data) {
        if (!this.areClose(instant, this.nextTs)) {
            this.put(instant);
        }
        this.put(data);
    }

    private boolean areClose(Instant instant, Instant nextTs) {
        if (nextTs == null) {
            return false;
        }
        Duration between = Duration.between(instant, nextTs);
        return Math.abs(between.getSeconds()) < this.period.duration() / 2L;
    }

    public void put(double[] data) {
        this.writeLine(this.toString(data));
        this.nextTs = this.period.next(this.nextTs);
    }

    private void writeLine(String line) {
        try {
            this.writer.write(line + "\n");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private String toString(double[] values) {
        return Arrays.stream(values).mapToObj(this::toString).collect(Collectors.joining("\t")).stripTrailing();
    }

    private String toString(double value) {
        return Double.isNaN(value) ? "" : this.format(value);
    }

    private String format(double value) {
        long v = (long)value;
        return value == (double)v ? String.valueOf(v) : String.valueOf(value);
    }

    @Override
    public void close() {
        this.resource.close();
    }
}

