/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zit;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.resourcecleaner.DisposableResource;
import io.intino.alexandria.zit.model.Data;
import io.intino.alexandria.zit.model.Period;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.Stream;

public class ItlReader
implements AutoCloseable {
    private final Stream<String> lines;
    private final DisposableResource resource;
    private String id;
    private String sensor;
    private Instant instant = null;
    private Period period = null;
    private String[] measurements;

    public ItlReader(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        this.resource = DisposableResource.whenDestroyed((Object)this).thenClose((Object)reader);
        this.readHeader(reader);
        this.lines = reader.lines();
    }

    public String id() {
        return this.id;
    }

    public String sensor() {
        return this.sensor;
    }

    public Period period() {
        return this.period;
    }

    public String[] measurements() {
        return this.measurements;
    }

    public Stream<Data> data() {
        return this.lines.map(this::parse).filter(Objects::nonNull);
    }

    private Data parse(String l) {
        if (ItlReader.isAnnotation(l)) {
            this.loadAnnotation(l);
            return null;
        }
        Data data = new Data(this.instant, this.loadMeasurement(l.split("\t")), this.measurements);
        this.instant = this.period.next(this.instant);
        return data;
    }

    private double[] loadMeasurement(String[] fields) {
        this.checkModel();
        double[] values = new double[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            values[i] = this.parseValue(fields[i]);
        }
        return values;
    }

    private static boolean isAnnotation(String line) {
        return line.startsWith("@");
    }

    private double parseValue(String s) {
        return s.isEmpty() ? Double.NaN : Double.parseDouble(s);
    }

    private void checkModel() {
        if (this.period == null) {
            throw new IllegalArgumentException("No period defined");
        }
        if (this.instant == null) {
            throw new IllegalArgumentException("No instant defined");
        }
        if (this.measurements == null) {
            throw new IllegalArgumentException("No measurements defined");
        }
    }

    private void loadAnnotation(String line) {
        int index = line.indexOf(32);
        if (index < 0) {
            return;
        }
        String metadata = line.substring(1, index).toLowerCase();
        String data = line.substring(index + 1);
        switch (metadata) {
            case "id": {
                this.id = data;
                break;
            }
            case "sensor": {
                this.sensor = data;
                break;
            }
            case "instant": {
                this.instant = Instant.parse(data);
                break;
            }
            case "period": {
                this.period = Period.of(data);
                break;
            }
            case "measurements": {
                this.measurements = data.split("\u0000");
            }
        }
    }

    private void readHeader(BufferedReader reader) {
        try {
            this.parse(reader.readLine());
            this.parse(reader.readLine());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public void close() {
        this.resource.close();
    }
}

