/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.xerial.snappy.SnappyInputStream;

public class ZimReader
implements ZimStream {
    public static final String ZimExtension = ".zim";
    private final Iterator<Message> iterator;
    private Message current;

    public ZimReader(File file) {
        this(ZimReader.iteratorOf(ZimReader.inputStream(file)));
    }

    public ZimReader(InputStream is) {
        this(ZimReader.iteratorOf(is instanceof SnappyInputStream ? is : ZimReader.snZipStreamOf(is)));
    }

    public ZimReader(String text) {
        this(ZimReader.iteratorOf(new ByteArrayInputStream(text.getBytes())));
    }

    public ZimReader(Message ... messages) {
        this(Arrays.stream(messages));
    }

    public ZimReader(List<Message> messages) {
        this(messages.stream());
    }

    public ZimReader(Stream<Message> stream) {
        this(stream.iterator());
    }

    public ZimReader(Iterator<Message> iterator) {
        this.iterator = iterator;
    }

    public Iterator<Message> iterator() {
        return this.iterator;
    }

    @Override
    public Message current() {
        return this.current;
    }

    @Override
    public Message next() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    private static Iterator<Message> iteratorOf(InputStream is) {
        final MessageReader source = ZimReader.readerOf(is);
        return new Iterator<Message>(){
            private Message current;
            private Message next;

            @Override
            public Message next() {
                if (this.current == this.next) {
                    this.hasNext();
                }
                this.current = this.next;
                return this.current;
            }

            private Message nextMessageFromSource() {
                return source.next();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (this.current != this.next) {
                    return true;
                }
                this.next = this.nextMessageFromSource();
                boolean bl = hasNext = this.next != null;
                if (!hasNext) {
                    source.close();
                }
                return hasNext;
            }
        };
    }

    private static MessageReader readerOf(InputStream is) {
        return new MessageReader(is);
    }

    private static InputStream inputStream(File file) {
        try {
            return ZimReader.snZipStreamOf(file);
        }
        catch (IOException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private static InputStream snZipStreamOf(File file) throws IOException {
        return new SnappyInputStream((InputStream)ZimReader.fileInputStream(file));
    }

    private static InputStream snZipStreamOf(InputStream stream) {
        try {
            return new SnappyInputStream(stream);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return stream;
        }
    }

    private static BufferedInputStream fileInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }
}

