/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageWriter;
import io.intino.alexandria.zim.ZimReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZimExtractor {
    private final ZimReader reader;
    private MessageWriter writer;

    private ZimExtractor(InputStream stream) {
        this.reader = new ZimReader(stream);
    }

    public void to(File folder) throws IOException {
        this.writer = this.messageWriterOf(folder);
        this.export(this.createIfNotExists(folder));
    }

    private File createIfNotExists(File folder) {
        folder.mkdirs();
        return folder;
    }

    private void export(File folder) throws IOException {
        while (this.reader.hasNext()) {
            Message message = this.reader.next();
            this.writer.write(message);
        }
        this.writer.close();
    }

    private MessageWriter messageWriterOf(File folder) throws FileNotFoundException {
        return new MessageWriter((OutputStream)new FileOutputStream(new File(folder, "zim.inl")));
    }

    public static ZimExtractor of(File file) throws FileNotFoundException {
        return ZimExtractor.of(new BufferedInputStream(new FileInputStream(file)));
    }

    public static ZimExtractor of(InputStream stream) {
        return new ZimExtractor(stream);
    }
}

