/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageWriter;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.xerial.snappy.SnappyOutputStream;

public class ZimBuilder {
    private final File source;

    public ZimBuilder(File file) {
        this.source = file;
        file.getParentFile().mkdirs();
    }

    public void put(Message ... messages) {
        this.put(new ZimReader(messages));
    }

    public void put(List<Message> messages) {
        this.put(new ZimReader(messages));
    }

    public void put(Stream<Message> stream) {
        this.put(new ZimReader(stream));
    }

    public void put(ZimStream zimStream) {
        try {
            Files.move(this.merge(zimStream).toPath(), this.source.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private File merge(ZimStream data) {
        File file = this.tempFile();
        try (MessageWriter writer = new MessageWriter((OutputStream)this.zipStream(file));){
            ZimStream stream = this.mergeFileWith(data);
            while (stream.hasNext()) {
                writer.write(stream.next());
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return file;
    }

    private SnappyOutputStream zipStream(File file) throws IOException {
        return new SnappyOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
    }

    private File tempFile() {
        try {
            return File.createTempFile("builder#", ".zim");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("builder#" + UUID.randomUUID().toString() + ".zim");
        }
    }

    private ZimStream mergeFileWith(ZimStream data) {
        return new ZimStream.Sequence(new ZimReader(this.source), data);
    }
}

