/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.inl.Event;
import io.intino.alexandria.inl.Message;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface ZimStream {
    public Message current();

    public Message next();

    public boolean hasNext();

    public static class Empty
    implements ZimStream {
        @Override
        public Message current() {
            return null;
        }

        @Override
        public Message next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }

    public static class Sequence
    implements ZimStream {
        private final Iterator<ZimStream> iterator;
        private Message currentMessage;
        private ZimStream current;

        private Sequence(ZimStream ... inputs) {
            this.iterator = this.streamOf(inputs).iterator();
            this.current = this.iterator.next();
        }

        public static Sequence of(ZimStream ... inputs) {
            return new Sequence(inputs);
        }

        private Stream<ZimStream> streamOf(ZimStream[] inputs) {
            return Arrays.stream(this.isEmpty(inputs) ? inputs : this.emptyInput());
        }

        private boolean isEmpty(ZimStream[] inputs) {
            return inputs.length > 0;
        }

        private ZimStream[] emptyInput() {
            return new ZimStream[]{new Empty()};
        }

        @Override
        public Message current() {
            return this.currentMessage;
        }

        @Override
        public Message next() {
            this.currentMessage = this.current.next();
            return this.currentMessage;
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext() || this.restHasNext();
        }

        private boolean restHasNext() {
            while (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    public static class Merge
    implements ZimStream {
        private Message currentMessage;
        private ZimStream[] inputs;
        private Event[] current;

        public Merge(ZimStream ... inputs) {
            this.inputs = inputs;
            this.current = (Event[])Arrays.stream(inputs).map(this::next).toArray(Event[]::new);
        }

        public static Merge of(ZimStream ... inputs) {
            return new Merge(inputs);
        }

        @Override
        public Message current() {
            return this.currentMessage;
        }

        @Override
        public Message next() {
            this.currentMessage = this.next(this.minIndex());
            return this.currentMessage;
        }

        private Message next(int index) {
            Event message = this.current[index];
            this.current[index] = this.next(this.inputs[index]);
            return message;
        }

        @Override
        public boolean hasNext() {
            return !Arrays.stream(this.current).allMatch(Objects::isNull);
        }

        private Event next(ZimStream input) {
            return input.hasNext() ? input.next().asEvent() : null;
        }

        private int minIndex() {
            return IntStream.range(0, this.current.length).boxed().min(this::comparingTimestamp).orElse(-1);
        }

        private int comparingTimestamp(int a, int b) {
            return Long.compare(this.tsOf(a), this.tsOf(b));
        }

        private long tsOf(int i) {
            return this.current[i] != null ? this.current[i].instant().toEpochMilli() : Long.MAX_VALUE;
        }
    }
}

