/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.inl.InlReader;
import io.intino.alexandria.inl.Message;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class ZimReader
implements ZimStream {
    public static final String ZimExtension = ".zim";
    private final Iterator<Message> iterator;
    private Message current;

    public ZimReader(File file) {
        this(ZimReader.iteratorOf(ZimReader.inputStream(file)));
    }

    public ZimReader(InputStream is) {
        this(ZimReader.iteratorOf(is));
    }

    public ZimReader(String text) {
        this(ZimReader.iteratorOf(new ByteArrayInputStream(text.getBytes())));
    }

    public ZimReader(Message ... messages) {
        this(Arrays.stream(messages));
    }

    public ZimReader(List<Message> messages) {
        this(messages.stream());
    }

    public ZimReader(Stream<Message> stream) {
        this(stream.sorted(Comparator.comparing(m -> m.asEvent().instant())).iterator());
    }

    public ZimReader(Iterator<Message> iterator) {
        this.iterator = iterator;
    }

    private static Iterator<Message> iteratorOf(InputStream is) {
        final InlReader source = ZimReader.readerOf(is);
        return new Iterator<Message>(){
            private Message current;
            private Message next;

            @Override
            public Message next() {
                if (this.current == this.next) {
                    this.hasNext();
                }
                this.current = this.next;
                return this.current;
            }

            private Message nextMessageFromSource() {
                return source.next();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (this.current != this.next) {
                    return true;
                }
                this.next = this.nextMessageFromSource();
                boolean bl = hasNext = this.next != null;
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            void close() {
                source.close();
            }
        };
    }

    private static InlReader readerOf(InputStream is) {
        return new InlReader(is);
    }

    private static InputStream inputStream(File file) {
        try {
            return ZimReader.zipStreamOf(file);
        }
        catch (IOException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private static InputStream zipStreamOf(File file) throws IOException {
        return new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    @Override
    public Message current() {
        return this.current;
    }

    @Override
    public Message next() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }
}

