/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.office;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.util.IOUtils;

public class XlsBuilder {
    private final HSSFWorkbook wb;
    private final HSSFCreationHelper helper;
    private final Map<Sheet, HSSFPatriarch> patriarchs = new HashMap<Sheet, HSSFPatriarch>();
    private final HSSFCellStyle level1;
    private final HSSFCellStyle level2;
    private final HSSFCellStyle boldLeft;
    private final HSSFCellStyle boldRight;
    private final HSSFCellStyle text;
    private final Set<Short> styles = new HashSet<Short>();

    private XlsBuilder() {
        this.wb = new HSSFWorkbook();
        this.helper = this.wb.getCreationHelper();
        this.level1 = this.style((Font)this.font(14, true));
        this.level2 = this.style((Font)this.font(12, true));
        this.boldLeft = this.style((Font)this.font(10, true), HorizontalAlignment.LEFT);
        this.boldRight = this.style((Font)this.font(10, true), HorizontalAlignment.RIGHT);
        this.text = this.style((Font)this.font(10, false), HorizontalAlignment.LEFT);
    }

    public static XlsBuilder create() {
        return new XlsBuilder();
    }

    public XlsBuilder append(String sheetName, File csvFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(csvFile));){
            this.create((Sheet)this.newSheet(sheetName), reader);
        }
        return this;
    }

    public XlsBuilder append(String sheetName, String csvContent) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(csvContent.getBytes())));){
            this.create((Sheet)this.newSheet(sheetName), reader);
        }
        return this;
    }

    private HSSFSheet newSheet(String sheetName) {
        HSSFSheet sheet = this.wb.createSheet(sheetName);
        this.patriarchs.put((Sheet)sheet, sheet.createDrawingPatriarch());
        return sheet;
    }

    public void save(File file) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(file);
        this.wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    private HSSFCellStyle style(Font font) {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setFont(font);
        this.styles.add(style.getIndex());
        return style;
    }

    private HSSFFont font(int size, boolean bold) {
        HSSFFont font = this.wb.createFont();
        font.setBold(bold);
        font.setFontHeightInPoints((short)size);
        return font;
    }

    private HSSFCellStyle style(Font font, HorizontalAlignment alignment) {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setFont(font);
        style.setAlignment(alignment);
        this.styles.add(style.getIndex());
        return style;
    }

    private HSSFCellStyle style(short format, HorizontalAlignment alignment) {
        HSSFCellStyle style = this.wb.createCellStyle();
        style.setDataFormat(format);
        style.setAlignment(alignment);
        style.setFont(this.font(10, false));
        return style;
    }

    private void create(Sheet sheet, BufferedReader reader) throws IOException {
        String line;
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#define")) {
                this.define(sheet, line);
            } else {
                this.create(sheet.createRow(i), line.split(";"));
            }
            ++i;
        }
    }

    private void define(Sheet sheet, String line) {
        String[] split = line.split(" ", 3);
        this.defineFor(split[1], split[2]).execute(sheet);
    }

    private void create(Row row, String[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.fill(row.createCell(i), data[i]);
        }
    }

    private void fill(Cell cell, String data) {
        CellStyle style = this.styleFor(data);
        if (style != null) {
            cell.setCellStyle(style);
        }
        if (this.hasComment(data)) {
            this.createComment(cell, this.commentOf(data));
        }
        this.fill(cell, this.contentOf(this.withoutComment(data)));
    }

    private boolean hasComment(String data) {
        return data.contains("~");
    }

    private String withoutComment(String data) {
        return data.split("~")[0];
    }

    private String commentOf(String data) {
        return data.split("~")[1];
    }

    private void fill(Cell cell, Object value) {
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            cell.setCellValue((String)value);
        }
        if (value instanceof HSSFRichTextString) {
            cell.setCellValue((RichTextString)((HSSFRichTextString)value));
        }
    }

    private void createComment(Cell cell, String value) {
        HSSFPatriarch patriarch = this.patriarchs.get(cell.getSheet());
        HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
        comment.setString((RichTextString)this.helper.createRichTextString(value));
        cell.setCellComment((Comment)comment);
    }

    private CellStyle styleFor(String value) {
        if (value.startsWith("*")) {
            return this.level1;
        }
        if (value.startsWith("**")) {
            return this.level2;
        }
        if (value.startsWith("$")) {
            return this.boldLeft;
        }
        if (value.startsWith("#")) {
            return this.boldRight;
        }
        if (value.startsWith(" ")) {
            return this.text;
        }
        return null;
    }

    private Object contentOf(String value) {
        value = value.replaceAll("^[#*$ ]*", "");
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    private boolean isStyled(String value) {
        return value.matches("[#*$ ].*");
    }

    private Define defineFor(String variable, String value) {
        if (variable.equalsIgnoreCase("text")) {
            return new DefineFactory().text(value);
        }
        if (variable.equalsIgnoreCase("image")) {
            return new DefineFactory().image(value);
        }
        if (variable.equalsIgnoreCase("column")) {
            return new DefineFactory().column(value);
        }
        if (variable.equalsIgnoreCase("columns")) {
            return new DefineFactory().columns(value);
        }
        if (variable.equalsIgnoreCase("cell")) {
            return new DefineFactory().cell(value);
        }
        if (variable.equalsIgnoreCase("background")) {
            return new DefineFactory().background(value);
        }
        if (variable.equalsIgnoreCase("freezing")) {
            return new DefineFactory().freezing(value);
        }
        if (variable.equalsIgnoreCase("border")) {
            return new DefineFactory().border(value);
        }
        return new DefineFactory().Null();
    }

    private HorizontalAlignment parseAlignment(String data) {
        if (data.equalsIgnoreCase("right")) {
            return HorizontalAlignment.RIGHT;
        }
        if (data.equalsIgnoreCase("center")) {
            return HorizontalAlignment.CENTER;
        }
        return HorizontalAlignment.LEFT;
    }

    private short parseFormat(String data) {
        return this.wb.createDataFormat().getFormat(data);
    }

    private class DefineFactory {
        private DefineFactory() {
        }

        public Define image(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    HSSFPicture picture = XlsBuilder.this.patriarchs.get(sheet).createPicture(this.createAnchor(), this.createPicture());
                    if (this.scaleX() != 1.0 || this.scaleY() != 1.0) {
                        picture.resize(this.scaleX(), this.scaleY());
                    } else {
                        picture.resize();
                    }
                }

                private ClientAnchor createAnchor() {
                    HSSFClientAnchor anchor = XlsBuilder.this.helper.createClientAnchor();
                    anchor.setCol1(this.col());
                    anchor.setRow1(this.row());
                    return anchor;
                }

                private int createPicture() {
                    try {
                        return XlsBuilder.this.wb.addPicture(IOUtils.toByteArray((InputStream)this.stream()), 6);
                    }
                    catch (IOException e) {
                        return -1;
                    }
                }

                private int row() {
                    return Integer.parseInt(this.split[0]);
                }

                private double scaleX() {
                    return Double.parseDouble(this.split[2]);
                }

                private double scaleY() {
                    return Double.parseDouble(this.split[3]);
                }

                private int col() {
                    return Integer.parseInt(this.split[1]);
                }

                private InputStream stream() {
                    return new ByteArrayInputStream(this.bytesOf(this.split[4]));
                }

                private byte[] bytesOf(String data) {
                    return Base64.getDecoder().decode(data);
                }
            };
        }

        public Define column(final String definition) {
            return new Define(){
                private HSSFCellStyle styleBold;
                private HSSFCellStyle style;
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    sheet.setColumnWidth(this.col(), this.size());
                    this.style = XlsBuilder.this.style(this.format(), this.alignment());
                    this.styleBold = XlsBuilder.this.style(this.format(), this.alignment());
                    this.styleBold.setFont(XlsBuilder.this.font(10, true));
                    this.setColumnStyle(sheet, this.col(), (CellStyle)this.style);
                }

                private void setColumnStyle(Sheet sheet, int column, CellStyle style) {
                    for (Row row : sheet) {
                        Cell cell = row.getCell(column);
                        if (cell == null) continue;
                        CellStyle cellStyle = cell.getCellStyle();
                        HSSFFont font = XlsBuilder.this.wb.getFontAt(cellStyle.getFontIndex());
                        if (XlsBuilder.this.styles.contains(cellStyle.getIndex()) && font.getFontHeight() != 10) continue;
                        cell.setCellStyle((CellStyle)(font.getBold() ? this.styleBold : style));
                    }
                }

                private int col() {
                    return Integer.parseInt(this.split[0]);
                }

                private int size() {
                    return Integer.parseInt(this.split[1]) * 520;
                }

                private HorizontalAlignment alignment() {
                    return XlsBuilder.this.parseAlignment(this.split[2]);
                }

                private short format() {
                    return XlsBuilder.this.parseFormat(this.split[3]);
                }
            };
        }

        public Define columns(final String definition) {
            return new Define(){
                private HSSFCellStyle styleBold;
                private HSSFCellStyle style;
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    this.style = XlsBuilder.this.style(this.format(), this.alignment());
                    this.styleBold = XlsBuilder.this.style(this.format(), this.alignment());
                    this.styleBold.setFont(XlsBuilder.this.font(10, true));
                    for (int i = this.firstCol(); i < this.lastCol(); ++i) {
                        sheet.setColumnWidth(i, this.size());
                        this.setColumnStyle(sheet, i, (CellStyle)this.style);
                    }
                }

                private void setColumnStyle(Sheet sheet, int column, CellStyle style) {
                    for (Row row : sheet) {
                        Cell cell = row.getCell(column);
                        if (cell == null) continue;
                        CellStyle cellStyle = cell.getCellStyle();
                        HSSFFont font = XlsBuilder.this.wb.getFontAt(cellStyle.getFontIndex());
                        if (XlsBuilder.this.styles.contains(cellStyle.getIndex()) && font.getFontHeight() != 10) continue;
                        cell.setCellStyle((CellStyle)(font.getBold() ? this.styleBold : style));
                    }
                }

                private int firstCol() {
                    return Integer.parseInt(this.split[0]);
                }

                private int lastCol() {
                    return Integer.parseInt(this.split[1]);
                }

                private int size() {
                    return Integer.parseInt(this.split[2]) * 520;
                }

                private HorizontalAlignment alignment() {
                    return XlsBuilder.this.parseAlignment(this.split[3]);
                }

                private short format() {
                    return XlsBuilder.this.parseFormat(this.split[4]);
                }
            };
        }

        public Define text(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    Cell cell = sheet.getRow(this.row()).createCell(this.col());
                    XlsBuilder.this.fill(cell, this.text());
                }

                private int row() {
                    return Integer.parseInt(this.split[0]);
                }

                private int col() {
                    return Integer.parseInt(this.split[1]);
                }

                private String text() {
                    return this.split[2];
                }
            };
        }

        public Define cell(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    this.cell(sheet).setCellStyle((CellStyle)XlsBuilder.this.style(this.format(), this.alignment()));
                }

                private Cell cell(Sheet sheet) {
                    return sheet.getRow(this.row()).getCell(this.col());
                }

                private int row() {
                    return Integer.parseInt(this.split[0]);
                }

                private int col() {
                    return Integer.parseInt(this.split[1]);
                }

                private HorizontalAlignment alignment() {
                    return XlsBuilder.this.parseAlignment(this.split[2]);
                }

                private short format() {
                    return XlsBuilder.this.parseFormat(this.split[3]);
                }
            };
        }

        public Define Null() {
            return sheet -> {};
        }

        public Define background(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    CellStyle backgroundStyle = sheet.getWorkbook().createCellStyle();
                    backgroundStyle.cloneStyleFrom(sheet.getRow(this.firstRow()).getCell(this.firstCol()).getCellStyle());
                    backgroundStyle.setFillForegroundColor(IndexedColors.valueOf((String)this.colorName()).getIndex());
                    backgroundStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    for (int i = this.firstRow(); i <= this.lastRow(); ++i) {
                        for (int j = this.firstCol(); j <= this.lastCol(); ++j) {
                            sheet.getRow(i).getCell(j).setCellStyle(backgroundStyle);
                        }
                    }
                }

                private int firstRow() {
                    return Integer.parseInt(this.split[0]);
                }

                private int lastRow() {
                    return Integer.parseInt(this.split[2]);
                }

                private int firstCol() {
                    return Integer.parseInt(this.split[1]);
                }

                private int lastCol() {
                    return Integer.parseInt(this.split[3]);
                }

                private String colorName() {
                    return this.split[4];
                }
            };
        }

        public Define freezing(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    sheet.createFreezePane(this.splitCol(), this.splitRow());
                }

                private int splitRow() {
                    return Integer.parseInt(this.split[0]);
                }

                private int splitCol() {
                    return Integer.parseInt(this.split[1]);
                }
            };
        }

        public Define border(final String definition) {
            return new Define(){
                private final String[] split;
                {
                    this.split = definition.split(":");
                }

                @Override
                public void execute(Sheet sheet) {
                    CellRangeAddress region = new CellRangeAddress(this.firstRow(), this.lastRow(), this.firstCol(), this.lastCol());
                    BorderStyle border = BorderStyle.valueOf((String)this.borderName());
                    RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
                    RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
                    RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
                    RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
                }

                private int firstRow() {
                    return Integer.parseInt(this.split[0]);
                }

                private int firstCol() {
                    return Integer.parseInt(this.split[1]);
                }

                private int lastRow() {
                    return Integer.parseInt(this.split[2]);
                }

                private int lastCol() {
                    return Integer.parseInt(this.split[3]);
                }

                private String borderName() {
                    return this.split[4];
                }
            };
        }
    }

    public static interface Define {
        public void execute(Sheet var1);
    }
}

