package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Upload;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class UploadRequester extends ActionableRequester {

	public UploadRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Upload display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("notifyUploading")) {
			display.notifyUploading(Integer.parseInt(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("add")) {
			display.add(manager.fromFormAsResource("v"));
			return;
		}
		else if (operation.equals("execute")) {
			display.execute();
			return;
		}

		super.execute();
	}
}