package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Upload;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class UploadPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		Upload display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("notifyUploading")) {
			display.notifyUploading(Integer.parseInt(data));
			return;
		}
		else if (operation.equals("execute")) {
			display.execute();
			return;
		}

		super.execute(client, message);
	}

}