package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.SignDocument;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class SignDocumentRequester extends SignActionRequester {

	public SignDocumentRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		SignDocument display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("execute")) {
			display.execute();
			return;
		}
		else if (operation.equals("batchSuccess")) {
			display.batchSuccess(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.SignDocumentSignatureSuccess[].class)));
			return;
		}

		super.execute();
	}
}