/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.reel;

import java.util.HashMap;
import java.util.Map;

public class SignalDefinition {
    private String name;
    private String color;
    private Type type = Type.Normal;
    private final Map<String, String> labelMap = new HashMap<String, String>();

    public String name() {
        return this.name;
    }

    public SignalDefinition name(String name) {
        this.name = name;
        return this;
    }

    public String color() {
        return this.color;
    }

    public SignalDefinition color(String color) {
        this.color = color;
        return this;
    }

    public String label(String language) {
        return this.labelMap.getOrDefault(language, this.name);
    }

    public SignalDefinition add(String language, String label) {
        this.labelMap.put(language, label);
        return this;
    }

    public Type type() {
        return this.type;
    }

    private SignalDefinition type(Type type) {
        this.type = type;
        return this;
    }

    public static SignalDefinition empty(String name) {
        return new SignalDefinition().name(name).type(Type.Empty);
    }

    public static enum Type {
        Normal,
        Empty;

    }
}

