/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.schemas.EventlineExecuteEventParams;
import io.intino.alexandria.schemas.EventlineSelectEventParams;
import io.intino.alexandria.ui.displays.components.Eventline;
import io.intino.alexandria.ui.displays.requesters.ComponentPushRequester;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import java.time.Instant;
import java.util.List;

public class EventlinePushRequester
extends ComponentPushRequester {
    @Override
    public void execute(UIClient client, UIMessage message) {
        Eventline display = (Eventline)this.display(client, message);
        if (display == null) {
            return;
        }
        String operation = this.operation(message);
        String data = this.data(message);
        if (operation.equals("update")) {
            display.update(data != null ? Instant.ofEpochMilli(Long.parseLong(data)) : null);
            return;
        }
        if (operation.equals("first")) {
            display.first();
            return;
        }
        if (operation.equals("previous")) {
            display.previous();
            return;
        }
        if (operation.equals("previousPage")) {
            display.previousPage();
            return;
        }
        if (operation.equals("next")) {
            display.next();
            return;
        }
        if (operation.equals("nextPage")) {
            display.nextPage();
            return;
        }
        if (operation.equals("last")) {
            display.last();
            return;
        }
        if (operation.equals("page")) {
            display.page(Integer.parseInt(data));
            return;
        }
        if (operation.equals("selectEvent")) {
            display.selectEvent((EventlineSelectEventParams)Json.fromString((String)data, EventlineSelectEventParams.class));
            return;
        }
        if (operation.equals("selectEvents")) {
            display.selectEvents(List.of((EventlineSelectEventParams[])Json.fromString((String)data, EventlineSelectEventParams[].class)));
            return;
        }
        if (operation.equals("executeEvent")) {
            display.executeEvent((EventlineExecuteEventParams)Json.fromString((String)data, EventlineExecuteEventParams.class));
            return;
        }
        super.execute(client, message);
    }
}

