/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services.libraries;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryArchetype;
import io.intino.alexandria.ui.utils.ZipHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class AlexandriaLibraryLoader
extends ClassLoader {
    private final AlexandriaLibraryArchetype archetype;
    private static final Map<String, Class<?>> Classes = new HashMap();
    private static final String I18nClass = "%s.I18n";
    private static final String ServiceClass = "%s.ui.%sElementsService";
    private static final String TemplateClass = "%s.ui.resources.%sResource";

    public AlexandriaLibraryLoader(AlexandriaLibraryArchetype archetype) {
        this.archetype = archetype;
        this.extractClasses();
    }

    byte[] getClassBytes(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        boolean eof = false;
        while (!eof) {
            try {
                int i = bis.read();
                if (i == -1) {
                    eof = true;
                    continue;
                }
                baos.write(i);
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
        return baos.toByteArray();
    }

    public Class<?> i18nClass() {
        try {
            return this.loadClass(String.format(I18nClass, this.archetype.rootPackage(), this.archetype.libraryName()));
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Class<?> serviceClass() {
        try {
            return this.loadClass(String.format(ServiceClass, this.archetype.rootPackage(), this.archetype.libraryName()));
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public Class<?> libraryTemplateEntryPointClass(String name) {
        try {
            return this.loadClass(String.format(TemplateClass, this.archetype.rootPackage(), AlexandriaLibraryLoader.firstUpperCase(name)));
        }
        catch (ClassNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public File webDirectory() {
        return this.archetype.webDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        InputStream is = null;
        try {
            if (Classes.containsKey(name)) {
                Class<?> clazz = Classes.get(name);
                return clazz;
            }
            File file = new File(this.basePath(), name.replace(".", "/") + ".class");
            if (!file.exists()) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
                return clazz;
            }
            is = new FileInputStream(file);
            byte[] buf = this.getClassBytes(is);
            Class<?> resultClass = this.defineClass(name, buf, 0, buf.length, null);
            if (this.isLayoutsClass(name)) {
                Classes.put(name, resultClass);
            }
            Class<?> clazz = resultClass;
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (FileNotFoundException e) {
            Logger.error((Throwable)e);
            return null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected URL findResource(String name) {
        try {
            File file = new File(this.basePath(), name);
            if (!file.exists()) {
                return super.findResource(name);
            }
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> superResources = super.findResources(name);
        ArrayList<URL> result = new ArrayList<URL>();
        while (superResources.hasMoreElements()) {
            result.add(superResources.nextElement());
        }
        File file = new File(this.basePath(), name);
        if (file.exists()) {
            result.add(file.toURI().toURL());
        }
        return Collections.enumeration(result);
    }

    private boolean isLayoutsClass(String name) {
        return new File(this.basePath(), name.replace(".", "/") + ".class").exists();
    }

    public static void reset() {
        Classes.clear();
    }

    private void extractClasses() {
        File[] files = this.archetype.directory().listFiles();
        if (files != null && files.length > 0) {
            return;
        }
        if (!this.archetype.directory().exists()) {
            this.archetype.directory().mkdirs();
        }
        if (!this.archetype.file().exists()) {
            return;
        }
        ZipHelper.extract(this.archetype.file(), this.archetype.directory());
    }

    private File basePath() {
        return this.archetype.directory();
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }
}

