/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractMaterialIcon;
import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.ui.displays.notifiers.MaterialIconNotifier;
import io.intino.alexandria.ui.resources.Asset;
import java.net.URL;

public class MaterialIcon<DN extends MaterialIconNotifier, B extends Box>
extends AbstractMaterialIcon<DN, B> {
    private static final String PngMaterialIcon = "/icons/mobile/%s.png";

    public MaterialIcon(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        if (this.session().browser().isMobile()) {
            this.refreshIcon();
        }
    }

    @Override
    protected MaterialIcon<DN, B> _icon(String materialIcon) {
        return (MaterialIcon)super._icon(materialIcon);
    }

    @Override
    public MaterialIcon<DN, B> icon(String icon) {
        return (MaterialIcon)super.icon(icon);
    }

    @Override
    protected MaterialIcon<DN, B> _darkIcon(String materialIcon) {
        return (MaterialIcon)super._darkIcon(materialIcon);
    }

    @Override
    public MaterialIcon<DN, B> darkIcon(String icon) {
        return (MaterialIcon)super.darkIcon(icon);
    }

    @Override
    public void init() {
        super.init();
        if (this.session().browser().isMobile()) {
            this.refreshIcon();
        }
    }

    @Override
    protected void refreshIcon() {
        ((MaterialIconNotifier)this.notifier).refreshIcon(this.iconReference(this.icon));
    }

    @Override
    protected void refreshDarkIcon() {
        ((MaterialIconNotifier)this.notifier).refreshDarkIcon(this.iconReference(this.darkIcon));
    }

    private String iconReference(String icon) {
        if (this.session().browser().isMobile()) {
            URL iconResource = Actionable.class.getResource(String.format(PngMaterialIcon, icon));
            return iconResource != null ? Asset.toResource(this.baseAssetUrl(), iconResource).setLabel(String.format(PngMaterialIcon, icon)).toUrl().toString() : icon;
        }
        return icon;
    }
}

