/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.services;

import io.intino.alexandria.ui.services.auth.FederationInfo;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.Verifier;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotLogout;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.alexandria.ui.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import java.net.URL;

public interface AuthService {
    public URL url();

    public Space space();

    public Authentication authenticate() throws SpaceAuthCallbackUrlIsNull;

    public boolean valid(Token var1);

    public FederationInfo info(Token var1) throws CouldNotObtainInfo;

    public UserInfo me(Token var1) throws CouldNotObtainInfo;

    public void logout(Token var1) throws CouldNotLogout;

    public String logoutUrl();

    public void addPushListener(Token var1, FederationNotificationListener var2) throws CouldNotObtainInfo;

    public static interface FederationNotificationListener {
        public void userLoggedOut(UserInfo var1);

        public void userAdded(UserInfo var1);
    }

    public static interface Authentication {
        public Token requestToken() throws CouldNotObtainRequestToken;

        public URL authenticationUrl(Token var1) throws CouldNotObtainAuthorizationUrl;

        public Token accessToken();

        public Token accessToken(Verifier var1) throws CouldNotObtainAccessToken;

        public void invalidate() throws CouldNotInvalidateAccessToken;

        public Version version();

        public static enum Version {
            OAuth1,
            OAuth2;

        }
    }
}

