/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.Actionable;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import io.intino.alexandria.ui.server.resources.Resource;
import io.intino.alexandria.ui.services.push.UIClient;

public abstract class DisplayRequester
extends Resource {
    public DisplayRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    public <D extends Display> D display() {
        return this.display(this.manager.fromPath("displayId"));
    }

    public <D extends Display> D display(String displayId) {
        if (displayId == null) {
            return null;
        }
        String[] data = this.manager.fromPath("displayId").split(":");
        UIClient<?> client = this.manager.currentClient();
        return client == null ? null : (D)((Soul)client.soul()).displayWithId(data[0], data[1], data[2]);
    }

    public String operation() {
        return this.manager.fromQuery("op");
    }

    @Override
    public void execute() throws AlexandriaException {
        Actionable display = (Actionable)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("refresh")) {
            display.refresh();
            return;
        }
        super.execute();
    }
}

