/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Scale;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.templates.AbstractEventlineExamplesMold;
import io.intino.alexandria.ui.model.eventline.EventlineDatasource;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class EventlineExamplesMold
extends AbstractEventlineExamplesMold<UiFrameworkBox> {
    public static final boolean WithJumps = true;

    public EventlineExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.eventline1.label("Events");
        this.eventline1.source(this.source());
        this.eventline1.onSelectEvent(e -> {
            this.notifyUser(String.format("Event %s selected", e.event().label()), UserMessage.Type.Info);
            this.eventline1.refresh(e.event().color("blue").icon("CheckBox", "New label").operations(Collections.emptyList()));
        });
        this.eventline1.onSelectEvents(e -> this.notifyUser("Events selected", UserMessage.Type.Info));
        this.eventline1.onExecuteEventOperation(e -> this.notifyUser(String.format("Execute operation %s for event %s", e.operation(), e.event().label()), UserMessage.Type.Info));
        this.eventline1.refresh();
        this.eventline2.label("Events");
        this.eventline2.onSelectEvent(e -> this.notifyUser(String.format("Event %s selected", e.event().label()), UserMessage.Type.Info));
        this.eventline2.onSelectEvents(e -> this.notifyUser("Events selected", UserMessage.Type.Info));
        this.eventline2.onExecuteEventOperation(e -> this.notifyUser(String.format("Execute operation %s for event %s", e.operation(), e.event().label()), UserMessage.Type.Info));
        this.eventline2.source(this.source());
        this.eventline2.refresh();
    }

    private EventlineDatasource source() {
        return new EventlineDatasource(){

            @Override
            public String name() {
                return "eld";
            }

            @Override
            public Map<Instant, List<EventlineDatasource.Event>> events(Instant start, Instant end) {
                Random random = new Random();
                Instant current = start;
                HashMap<Instant, List<EventlineDatasource.Event>> result = new HashMap<Instant, List<EventlineDatasource.Event>>();
                while (current.isBefore(end)) {
                    result.put(current, EventlineExamplesMold.randomEvents(current));
                    current = current.plus((long)random.nextInt(40), this.scale().temporalUnit());
                }
                return result;
            }

            @Override
            public Scale scale() {
                return Scale.Hour;
            }

            @Override
            public Instant from() {
                return LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).minus(500L, this.scale().temporalUnit()).toInstant(ZoneOffset.UTC);
            }

            @Override
            public Instant to() {
                return Instant.now();
            }
        };
    }

    private static List<EventlineDatasource.Event> randomEvents(Instant date) {
        Random random = new Random();
        int value = random.nextInt(7);
        if (value == 0) {
            return List.of(EventlineExamplesMold.event("1", date, "infrequent-value.1 hour. Trigger value 112846.0"));
        }
        if (value == 1) {
            return List.of(EventlineExamplesMold.event("2", date, "Event 2", "Anomalies"), EventlineExamplesMold.event("3", date, "Event 3", "Data wrong"));
        }
        if (value == 2) {
            return List.of(EventlineExamplesMold.event("4", date, "Event 4"));
        }
        if (value == 3) {
            return List.of(EventlineExamplesMold.event("5", date, "Event 5"), EventlineExamplesMold.event("6", date, "Event 6", "Data wrong"), EventlineExamplesMold.event("7", date, "Event 7"));
        }
        if (value == 4) {
            return List.of(EventlineExamplesMold.event("8", date, "Event 8"));
        }
        if (value == 5) {
            return List.of(EventlineExamplesMold.event("9", date, "Event 9. This is an event description", "Anomalies"));
        }
        if (value == 6) {
            return List.of(EventlineExamplesMold.event("10", date, "Event 10. This is an event description"));
        }
        return List.of(EventlineExamplesMold.event("11", date, "Event 11"));
    }

    private static EventlineDatasource.Event event(String id, Instant date, String label) {
        return new EventlineDatasource.Event(id, date, label).operations(List.of("Create order..."));
    }

    private static EventlineDatasource.Event event(String id, Instant date, String label, String category) {
        return new EventlineDatasource.Event(id, date, label, category).operations(List.of("Create order..."));
    }
}

