/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.WizardInfo;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractWizard;
import io.intino.alexandria.ui.displays.components.Step;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.StepEvent;
import io.intino.alexandria.ui.displays.events.StepListener;
import io.intino.alexandria.ui.displays.notifiers.WizardNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Wizard<DN extends WizardNotifier, B extends Box>
extends AbstractWizard<B> {
    private List<StepListener> stepArrivalListeners = new ArrayList<StepListener>();
    private List<Listener> finishListeners = new ArrayList<Listener>();
    protected int active = 0;
    private boolean finished = false;

    public Wizard(B box) {
        super(box);
    }

    public Wizard<DN, B> onStepArrival(StepListener listener) {
        this.stepArrivalListeners.add(listener);
        return this;
    }

    public Wizard<DN, B> onFinish(Listener listener) {
        this.finishListeners.add(listener);
        return this;
    }

    public boolean allowBack() {
        return this.active >= 1;
    }

    public boolean canBack() {
        return this.canBack(this.active);
    }

    public boolean allowNext() {
        return this.active < this.stepsCount() - 1;
    }

    public boolean canNext() {
        return this.canNext(this.active);
    }

    public boolean allowFinish() {
        return this.active == this.stepsCount() - 1;
    }

    public boolean canFinish() {
        return this.canFinish(this.active);
    }

    public boolean finished() {
        return this.finished;
    }

    @Override
    public <D extends Display> D register(D child) {
        D registered = super.register(child);
        if (child instanceof Step) {
            ((Step)child).visible(true);
        }
        this.refreshInfo();
        this.refreshSteps();
        return registered;
    }

    @Override
    public void add(Step step) {
        this.add(step, "steps");
    }

    public void reset() {
        this.finished = false;
        this.select(0);
    }

    public void select(Step step) {
        this.select(this.posOf(step));
    }

    public void select(int pos) {
        this.active = pos;
        this.finished = false;
        this.refreshInfo();
        this.refreshSteps();
        this.notifyStepArrival();
    }

    public void back() {
        if (!this.canBack()) {
            return;
        }
        this.doBack();
        this.select(this.active);
    }

    public void next() {
        if (!this.canNext()) {
            return;
        }
        this.doNext();
        this.select(this.active);
    }

    public void finish() {
        ((WizardNotifier)this.notifier).showConfirmDialog();
    }

    public void finishConfirmed() {
        this.doFinish();
    }

    private void doFinish() {
        this.finished = true;
        this.refreshSteps();
        this.finishListeners.forEach(l -> l.accept(new Event(this)));
    }

    protected List<Step> steps() {
        return this.children(Step.class);
    }

    protected int active() {
        return this.active;
    }

    protected boolean canNext(int index) {
        return index < this.stepsCount() - 1 && this.stepOf(index).allowNext();
    }

    protected boolean canFinish(int index) {
        return index == this.stepsCount() - 1 && !this.finishListeners.isEmpty();
    }

    protected boolean canBack(int index) {
        return index > 0 && this.stepOf(index).allowBack();
    }

    private void doNext() {
        List<Boolean> visibility = this.stepsVisibility();
        do {
            ++this.active;
        } while (this.active < visibility.size() && !visibility.get(this.active).booleanValue());
    }

    private void doBack() {
        this.finished = false;
        List<Boolean> visibility = this.stepsVisibility();
        do {
            --this.active;
        } while (this.active > 0 && !visibility.get(this.active).booleanValue());
    }

    private void refreshInfo() {
        ((WizardNotifier)this.notifier).refresh(new WizardInfo().active(this.active).allowBack(this.allowBack()).allowNext(this.allowNext()).allowFinish(this.allowFinish()).visibleList(this.stepsVisibility()));
    }

    private List<Boolean> stepsVisibility() {
        return this.steps().stream().map(Component::isVisible).collect(Collectors.toList());
    }

    private int stepsCount() {
        return (int)this.steps().stream().filter(Component::isVisible).count();
    }

    private Step stepOf(int index) {
        return this.steps().get(index);
    }

    private int posOf(Step<?, ?> step) {
        List<Step> steps = this.steps();
        for (int i = 0; i < steps.size(); ++i) {
            if (steps.get(i) != step) continue;
            return i;
        }
        return -1;
    }

    private void notifyStepArrival() {
        this.stepArrivalListeners.forEach(l -> l.accept(new StepEvent(this, this.stepOf(this.active))));
    }

    private void refreshSteps() {
        int index = 0;
        for (Step step : this.steps()) {
            step._isActive(index == this.active);
            step._isCompleted(index < this.active || this.finished);
            if (index == this.active) {
                step.show();
            }
            step.refresh();
            ++index;
        }
    }
}

