/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.HtmlViewerOperation;
import io.intino.alexandria.ui.displays.components.AbstractHtmlViewer;
import io.intino.alexandria.ui.displays.notifiers.HtmlViewerNotifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class HtmlViewer<DN extends HtmlViewerNotifier, B extends Box>
extends AbstractHtmlViewer<B> {
    private String content;
    private final Map<String, Consumer<List<String>>> operationListeners = new HashMap<String, Consumer<List<String>>>();

    public HtmlViewer(B box) {
        super(box);
    }

    public HtmlViewer<DN, B> content(String content) {
        this.content = content;
        return this;
    }

    public HtmlViewer<DN, B> on(String operation, Consumer<List<String>> listener) {
        this.operationListeners.put(operation, listener);
        return this;
    }

    public void print() {
        this.print(null);
    }

    public void print(String title) {
        ((HtmlViewerNotifier)this.notifier).print(title);
    }

    public void execute(HtmlViewerOperation operation) {
        if (!this.operationListeners.containsKey(operation.name())) {
            return;
        }
        this.operationListeners.get(operation.name()).accept(operation.params());
    }

    @Override
    public void refresh() {
        super.refresh();
        ((HtmlViewerNotifier)this.notifier).refresh(this.content);
        if (!this.operationListeners.isEmpty()) {
            ((HtmlViewerNotifier)this.notifier).refreshOperations(new ArrayList<String>(this.operationListeners.keySet()));
        }
    }
}

