/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.AbstractFileEditable;
import io.intino.alexandria.ui.displays.components.File;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.FileEditableNotifier;
import io.intino.alexandria.ui.server.UIFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class FileEditable<DN extends FileEditableNotifier, B extends Box>
extends AbstractFileEditable<DN, B>
implements Editable<DN, B> {
    private boolean readonly;
    private List<String> allowedTypes;
    protected Listener uploadingListener = null;
    protected Listener downloadStartedListener = null;
    protected Listener downloadFinishedListener = null;
    protected ChangeListener changeListener = null;
    private ReadonlyListener readonlyListener = null;
    private File preview;
    private long maxSize;

    public FileEditable(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    @Override
    public void init() {
        super.init();
        this.createPreview();
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public void reload() {
        ((FileEditableNotifier)this.notifier).refresh(this.info());
    }

    @Override
    public FileEditable<DN, B> focus() {
        ((FileEditableNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    @Override
    public FileEditable<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        this.notifyReadonly(readonly);
        return this;
    }

    public FileEditable<DN, B> allowedTypes(List<Type> types) {
        this._allowedTypes(types);
        this.notifyAllowedTypes(types.stream().map(Enum::name).collect(Collectors.toList()));
        return this;
    }

    public FileEditable<DN, B> allowedTypesByName(List<String> types) {
        this._allowedTypesByName(types);
        this.notifyAllowedTypes(types);
        return this;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public FileEditable<DN, B> maxSize(long value) {
        this._maxSize(value);
        this.notifyMaxSize(value);
        return this;
    }

    public FileEditable<DN, B> onUploading(Listener listener) {
        this.uploadingListener = listener;
        return this;
    }

    public FileEditable<DN, B> onDownloadStarted(Listener listener) {
        this.downloadStartedListener = listener;
        return this;
    }

    public FileEditable<DN, B> onDownloadFinished(Listener listener) {
        this.downloadFinishedListener = listener;
        return this;
    }

    @Override
    public FileEditable<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    @Override
    public FileEditable<DN, B> onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    @Override
    public void refresh() {
        this.refreshPreview();
        ((FileEditableNotifier)this.notifier).refresh(this.info());
    }

    public void notifyUploading() {
        if (this.uploadingListener != null) {
            this.uploadingListener.accept(new Event(this));
        }
    }

    public void notifyDownloadStarted() {
        if (this.downloadStartedListener != null) {
            this.downloadStartedListener.accept(new Event(this));
        }
    }

    public void notifyDownloadFinished() {
        if (this.downloadFinishedListener != null) {
            this.downloadFinishedListener.accept(new Event(this));
        }
    }

    public void notifyChange(Resource value) {
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, value));
        }
    }

    public UIFile downloadFile() {
        final URL value = this.value();
        return new UIFile(){

            @Override
            public String label() {
                if (FileEditable.this.filename() != null) {
                    return URLEncoder.encode(FileEditable.this.filename(), StandardCharsets.UTF_8);
                }
                String path = value.getPath();
                return path.contains("/") ? path.substring(path.lastIndexOf("/") + 1) : path;
            }

            @Override
            public InputStream content() {
                try {
                    FileEditable.this.notifyDownloadStarted();
                    InputStream result = value.openStream();
                    FileEditable.this.notifyDownloadFinished();
                    return result;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return new ByteArrayInputStream(new byte[0]);
                }
            }
        };
    }

    protected FileEditable<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    protected FileEditable<DN, B> _allowedTypes(List<Type> allowedTypes) {
        this._allowedTypesByName(allowedTypes.stream().map(Enum::name).collect(Collectors.toList()));
        return this;
    }

    protected FileEditable<DN, B> _allowedTypesByName(List<String> allowedTypes) {
        this.allowedTypes = allowedTypes;
        return this;
    }

    protected FileEditable<DN, B> _maxSize(long value) {
        this.maxSize = value;
        return this;
    }

    private void createPreview() {
        this.preview = (File)new File(this.box()).id(UUID.randomUUID().toString());
        this.add(this.preview, "__elements");
    }

    private void refreshPreview() {
        this.preview.visible(this.value() != null);
        this.preview.value(this.value(), this.mimeType());
    }

    private void notifyReadonly(boolean value) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, value));
        }
        ((FileEditableNotifier)this.notifier).refreshReadonly(value);
    }

    private void notifyAllowedTypes(List<String> types) {
        ((FileEditableNotifier)this.notifier).refreshAllowedTypes(new ArrayList<String>(types));
    }

    private void notifyMaxSize(long value) {
        ((FileEditableNotifier)this.notifier).refreshMaxSize(value);
    }

    public static enum Type {
        Image,
        Audio,
        Video,
        Application,
        Text,
        Xml,
        Html,
        Pdf,
        Excel,
        Zip,
        Jar;

    }
}

