/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractCloseBlock;
import io.intino.alexandria.ui.displays.components.BlockConditional;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.actionable.CloseListener;
import io.intino.alexandria.ui.displays.notifiers.CloseBlockNotifier;

public class CloseBlock<DN extends CloseBlockNotifier, B extends Box>
extends AbstractCloseBlock<DN, B> {
    private BlockConditional block;
    private CloseListener closeListener = null;

    public CloseBlock(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        ((CloseBlockNotifier)this.notifier).refreshVisibility(this.visible());
    }

    public CloseBlock<DN, B> onClose(CloseListener listener) {
        this.closeListener = listener;
        return this;
    }

    public CloseBlock<DN, B> bindTo(BlockConditional<?, ?> block) {
        this.block = block;
        this.updateState();
        return this;
    }

    public void execute() {
        if (this.block != null) {
            this.block.hide();
        }
        if (this.closeListener != null) {
            this.closeListener.accept(new Event(this));
        }
    }

    private void updateState() {
        if (this.block == null) {
            return;
        }
        this.block.onShow(e -> this.show());
        this.block.onHide(e -> this.hide());
        this.visible(this.block.isVisible());
    }
}

