/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Base64;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.ActionableInfo;
import io.intino.alexandria.schemas.ActionableSign;
import io.intino.alexandria.schemas.ActionableSignInfo;
import io.intino.alexandria.totp.Totp;
import io.intino.alexandria.ui.displays.Component;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.actionable.SignChecker;
import io.intino.alexandria.ui.displays.components.actionable.SignInfo;
import io.intino.alexandria.ui.displays.components.actionable.SignInfoProvider;
import io.intino.alexandria.ui.displays.events.BeforeListener;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.ActionableNotifier;
import io.intino.alexandria.ui.resources.Asset;
import io.intino.alexandria.ui.server.UIFile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

public abstract class Actionable<DN extends ActionableNotifier, B extends Box>
extends Component<DN, B> {
    private String title;
    private boolean readonly = false;
    private String icon;
    private String darkIcon;
    private Mode mode;
    private SignChecker signChecker;
    private SignMode signMode;
    private String signReason;
    private SignInfoProvider signInfoProvider;
    private SignInfo signInfo;
    private BeforeListener beforeAffirmListener;
    private Listener cancelAffirmListener;
    private ReadonlyListener readonlyListener = null;
    private static final String PngMaterialIcon = "/icons/mobile/%s.png";

    public Actionable(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refreshIconIfRequired();
        this.refreshDarkIconIfRequired();
        this.refreshSignInfo();
    }

    public String title() {
        return this.title;
    }

    public Actionable<DN, B> title(String title) {
        this._title(title);
        this.refresh();
        return this;
    }

    public Actionable<DN, B> icon(String icon) {
        this._icon(icon);
        this.refreshIcon();
        return this;
    }

    public Actionable<DN, B> darkIcon(String icon) {
        this._icon(icon);
        this.refreshDarkIcon();
        return this;
    }

    public Actionable<DN, B> readonly(boolean readonly) {
        if (readonly) {
            this.disable();
        } else {
            this.enable();
        }
        return this;
    }

    public boolean disabled() {
        return this.readonly;
    }

    public Actionable<DN, B> highlight(Highlight highlight) {
        ((ActionableNotifier)this.notifier).refreshHighlight(highlight.name());
        return this;
    }

    public Actionable<DN, B> affirmed(String text) {
        ((ActionableNotifier)this.notifier).refreshAffirmed(text);
        return this;
    }

    public Actionable<DN, B> enable() {
        this._readonly(false);
        this.notifyReadonly(this.readonly);
        return this;
    }

    public Actionable<DN, B> disable() {
        this._readonly(true);
        this.notifyReadonly(this.readonly);
        return this;
    }

    public void launch() {
        ((ActionableNotifier)this.notifier).launch();
    }

    @Override
    public void refresh() {
        this.refreshInfo();
        this.refreshIconIfRequired();
        this.refreshDarkIconIfRequired();
    }

    private void refreshInfo() {
        ((ActionableNotifier)this.notifier).refresh(new ActionableInfo().title(this.title()).disabled(this.disabled()));
    }

    public void notifyUser(String message) {
        this.notifyUser(message, UserMessage.Type.Info);
    }

    public void setupSign(ActionableSign info) {
        this.signInfo = new SignInfo().secret(info.secret()).canSetup(true);
        if (this.signChecker == null) {
            ((ActionableNotifier)this.notifier).setupSignResult(true);
        }
        ((ActionableNotifier)this.notifier).setupSignResult(this.signChecker.check(info.sign(), "Setting up sign configuration"));
    }

    public void checkSign(ActionableSign info) {
        if (this.signChecker == null) {
            ((ActionableNotifier)this.notifier).checkSignResult(true);
        }
        ((ActionableNotifier)this.notifier).checkSignResult(this.signChecker.check(info.sign(), info.reason()));
        this.signReason = info.reason();
    }

    public void cancelAffirm(Boolean value) {
        if (this.cancelAffirmListener == null) {
            return;
        }
        this.cancelAffirmListener.accept(new Event(this));
    }

    public Actionable<DN, B> onBeforeAffirmed(BeforeListener listener) {
        this.beforeAffirmListener = listener;
        return this;
    }

    public Actionable<DN, B> onCancelAffirmed(Listener listener) {
        this.cancelAffirmListener = listener;
        return this;
    }

    public Actionable<DN, B> onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    public String signReason() {
        return this.signReason;
    }

    @Override
    public void init() {
        super.init();
        this.refreshIconIfRequired();
        this.refreshDarkIconIfRequired();
        this.refreshSignInfo();
    }

    public final void checkAffirmed() {
        ((ActionableNotifier)this.notifier).refreshAffirmedRequired(this.beforeAffirmListener == null || this.beforeAffirmListener.accept(new Event(this)));
    }

    public final void beforeSigned() {
        this.signInfo = this.signInfoProvider != null ? this.signInfoProvider.signInfo() : this.signInfo;
        this.refreshSignInfo();
        ((ActionableNotifier)this.notifier).continueSigned();
    }

    protected Actionable<DN, B> _title(String title) {
        this.title = title;
        return this;
    }

    protected Actionable<DN, B> _mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    protected Actionable<DN, B> _icon(String icon) {
        this.icon = icon;
        return this;
    }

    protected Actionable<DN, B> _darkIcon(String icon) {
        this.darkIcon = icon;
        return this;
    }

    protected Actionable<DN, B> _readonly(boolean value) {
        this.readonly = value;
        return this;
    }

    protected Actionable<DN, B> _signMode(SignMode mode) {
        this.signMode = mode;
        return this;
    }

    protected Actionable<DN, B> _signInfoProvider(SignInfoProvider provider) {
        this.signInfoProvider = provider;
        return this;
    }

    protected String _signSecret() {
        return this.signInfo != null ? this.signInfo.secret() : null;
    }

    protected Actionable<DN, B> _signChecker(SignChecker checker) {
        this.signChecker = checker;
        return this;
    }

    protected SignChecker _oneTimePassword() {
        return (sign, reason) -> Totp.check((String)this.signInfo.secret(), (String)sign);
    }

    protected void refreshSignInfo() {
        if (this.signMode != SignMode.OneTimePassword) {
            return;
        }
        String secret = this.signSecret();
        ((ActionableNotifier)this.notifier).refreshSignInfo(new ActionableSignInfo().canSetup(this.signCanSetup()).setupRequired(this.signSetupRequired()).secret(secret).secretImage(this.signSecretImage(secret)));
    }

    private String signSecretImage(String secret) {
        String company = this.signInfo != null && this.signInfo.company() != null ? this.signInfo.company() : "Company";
        String email = this.signInfo != null && this.signInfo.email() != null ? this.signInfo.email() : "info@company.com";
        return Base64.encode((byte[])Totp.qrImage((String)secret, (String)email, (String)company));
    }

    UIFile defaultFile() {
        return new UIFile(){

            @Override
            public String label() {
                return Actionable.this.title();
            }

            @Override
            public InputStream content() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }

    private void refreshIconIfRequired() {
        if (this.isResourceIcon()) {
            this.refreshIcon();
        }
        if (this.isMaterialIcon() && this.session().browser().isMobile()) {
            this.refreshIcon();
        }
    }

    private void refreshDarkIconIfRequired() {
        if (this.isResourceDarkIcon()) {
            this.refreshDarkIcon();
        }
        if (this.isMaterialDarkIcon() && this.session().browser().isMobile()) {
            this.refreshDarkIcon();
        }
    }

    private void refreshIcon() {
        ((ActionableNotifier)this.notifier).refreshIcon(this.icon());
    }

    private void refreshDarkIcon() {
        ((ActionableNotifier)this.notifier).refreshDarkIcon(this.darkIcon());
    }

    private String icon() {
        return this.iconOf(this.icon);
    }

    private String darkIcon() {
        return this.iconOf(this.darkIcon);
    }

    private String iconOf(String darkIcon) {
        if (this.isResourceIcon()) {
            return Asset.toResource(this.baseAssetUrl(), Actionable.class.getResource(darkIcon)).toUrl().toString();
        }
        if (this.isMaterialIcon() && this.session().browser().isMobile()) {
            URL iconResource = Actionable.class.getResource(String.format(PngMaterialIcon, darkIcon));
            return iconResource != null ? Asset.toResource(this.baseAssetUrl(), iconResource).setLabel(String.format(PngMaterialIcon, darkIcon)).toUrl().toString() : darkIcon;
        }
        return darkIcon;
    }

    private boolean isResourceIcon() {
        return (this.mode == Mode.IconButton || this.mode == Mode.IconToggle || this.mode == Mode.IconSplitButton) && this.icon != null && Actionable.class.getResource(this.icon) != null;
    }

    private boolean isResourceDarkIcon() {
        if (this.darkIcon == null) {
            return false;
        }
        return (this.mode == Mode.IconButton || this.mode == Mode.IconToggle || this.mode == Mode.IconSplitButton) && this.icon != null && Actionable.class.getResource(this.darkIcon) != null;
    }

    private boolean isMaterialIcon() {
        return (this.mode == Mode.MaterialIconButton || this.mode == Mode.MaterialIconToggle || this.mode == Mode.MaterialIconSplitButton) && this.icon != null;
    }

    private boolean isMaterialDarkIcon() {
        return (this.mode == Mode.MaterialIconButton || this.mode == Mode.MaterialIconToggle || this.mode == Mode.MaterialIconSplitButton) && this.darkIcon != null;
    }

    private boolean signCanSetup() {
        return this.signInfoProvider != null ? this.signInfoProvider.canSetup() : this.signInfo == null || this.signInfo.canSetup();
    }

    private boolean signSetupRequired() {
        return this.signMode == SignMode.OneTimePassword && (this.signInfo == null || this.signInfo.secret() == null);
    }

    private String signSecret() {
        if (this.signMode != SignMode.OneTimePassword) {
            return null;
        }
        if (this.signInfo != null && this.signInfo.secret() != null) {
            return this.signInfo.secret();
        }
        return Totp.createSecret();
    }

    private void notifyReadonly(boolean readonly) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, readonly));
        }
        ((ActionableNotifier)this.notifier).refreshReadonly(readonly);
    }

    public static enum Highlight {
        None,
        Outline,
        Fill;

    }

    public static enum Mode {
        Link,
        Button,
        IconButton,
        MaterialIconButton,
        Toggle,
        IconToggle,
        MaterialIconToggle,
        SplitButton,
        IconSplitButton,
        MaterialIconSplitButton,
        AvatarIconButton;

    }

    public static enum SignMode {
        SimpleText,
        SimplePassword,
        OneTimePassword;

    }
}

