/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.ChatSendMessageInfo;
import io.intino.alexandria.ui.displays.components.Chat;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.ComponentRequester;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ChatRequester
extends ComponentRequester {
    public ChatRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        Chat display = (Chat)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("executeOperation")) {
            display.executeOperation(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("sendMessage")) {
            display.sendMessage((ChatSendMessageInfo)Json.fromString((String)this.manager.fromQuery("v"), ChatSendMessageInfo.class));
            return;
        }
        if (operation.equals("sendAttachment")) {
            display.sendAttachment(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("uploadAttachment")) {
            display.uploadAttachment(this.manager.fromFormAsResource("v"));
            return;
        }
        if (operation.equals("previousMessages")) {
            display.previousMessages();
            return;
        }
        super.execute();
    }
}

