package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseGrouping;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class BaseGroupingRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public BaseGroupingRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		BaseGrouping display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("setupAddress")) {
			display.setupAddress(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), String[].class)));
			return;
		}
		else if (operation.equals("select")) {
			display.select(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), String[].class)));
			return;
		}

		super.execute();
	}
}