/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.chat.buckets;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.model.chat.Message;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class BucketMessageWriter {
    private final File file;
    private final List<String> messages;

    public BucketMessageWriter(File file) {
        this.file = file;
        this.messages = this.load();
    }

    public void add(Message message) {
        this.messages.add(Json.toString((Object)message));
    }

    public void save() {
        try {
            this.file.getParentFile().mkdirs();
            Files.writeString(this.file.toPath(), (CharSequence)String.join((CharSequence)"\n", this.messages), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private List<String> load() {
        try {
            if (!this.file.exists()) {
                return new ArrayList<String>();
            }
            return Files.readAllLines(this.file.toPath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new ArrayList<String>();
        }
    }
}

