package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.ProxyDisplay;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class ProxyDisplayPushRequester extends io.intino.alexandria.ui.displays.requesters.DisplayPushRequester {

	public void execute(UIClient client, UIMessage message) {
		ProxyDisplay display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("connected")) {
			display.connected();
			return;
		}
		else if (operation.equals("ready")) {
			display.ready();
			return;
		}
		else if (operation.equals("notifyMessage")) {
			display.notifyMessage(data);
			return;
		}

		super.execute(client, message);
	}

}