package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.MicroSite;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class MicroSiteRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public MicroSiteRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		MicroSite display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("download")) {
			io.intino.alexandria.ui.server.UIFile file = display.download();
			if (file == null) return;
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}
		else if (operation.equals("downloadContent")) {
			io.intino.alexandria.ui.server.UIFile file = display.downloadContent();
			if (file == null) return;
			manager.write(file.content(), file.label(), file.embedded());
			return;
		}

		super.execute();
	}
}