/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Base64;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.schemas.SignDocumentBatchEntry;
import io.intino.alexandria.schemas.SignDocumentSignatureSuccess;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.AbstractSignDocument;
import io.intino.alexandria.ui.displays.components.SignAction;
import io.intino.alexandria.ui.displays.events.SignEvent;
import io.intino.alexandria.ui.displays.notifiers.SignDocumentNotifier;
import io.intino.alexandria.ui.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class SignDocument<DN extends SignDocumentNotifier, B extends Box>
extends AbstractSignDocument<DN, B> {
    private SignProvider provider;
    private BeforeSignChecker beforeSignChecker;

    public SignDocument(B box) {
        super(box);
        this._signFormat(SignAction.SignFormat.PAdES);
    }

    public void document(URL document) {
        this.provider = () -> {
            try {
                return document.openStream();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        };
    }

    public void documents(List<URL> documents) {
        this.provider = () -> documents.stream().map(d -> {
            try {
                return d.openStream();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void documentProvider(DocumentProvider provider) {
        this.provider = provider;
    }

    public void documentProvider(BatchProvider provider) {
        this.provider = provider;
    }

    public void beforeSignChecker(BeforeSignChecker checker) {
        this.beforeSignChecker = checker;
    }

    public void execute() {
        if (this.provider == null) {
            this.notifyUser(this.translate("Indicate document to sign"), UserMessage.Type.Error);
            return;
        }
        if (!this.canSign()) {
            this.notifyUser(this.translate(this.cantSignMessage()), UserMessage.Type.Error);
            return;
        }
        this.sign();
        ((SignDocumentNotifier)this.notifier).refreshReadonly(true);
    }

    public void batchSuccess(List<SignDocumentSignatureSuccess> successList) {
        List<SignEvent.SignEventInfo> signEventInfoList = successList.stream().map(this::signInfoOf).collect(Collectors.toList());
        this.notifyUser(this.translate(this.signSuccessMessage), UserMessage.Type.Success);
        this.signListener.accept(new SignEvent(this, signEventInfoList));
    }

    private SignEvent.SignEventInfo signInfoOf(SignDocumentSignatureSuccess success) {
        return new SignEvent.SignEventInfo(success.id(), success.signature(), success.certificate(), this.info(success.signature()));
    }

    private void sign() {
        if (this.provider instanceof BatchProvider) {
            this.signBatch(((BatchProvider)this.provider).documents());
        } else {
            this.signDocument(((DocumentProvider)this.provider).document());
        }
    }

    private void signBatch(List<InputStream> documentList) {
        List documentUrlList = documentList.stream().map(d -> this.server.store(UUID.randomUUID().toString(), (InputStream)d)).collect(Collectors.toList());
        if (documentUrlList.stream().anyMatch(Objects::isNull)) {
            this.notifyUser(this.translate("Could not sign documents in batch"), UserMessage.Type.Error);
            return;
        }
        ((SignDocumentNotifier)this.notifier).signBatch(documentUrlList.stream().map(this::schemaOf).collect(Collectors.toList()));
    }

    private void signDocument(InputStream documentStream) {
        this.sign(this.signMode() == SignAction.SignMode.CounterSign ? this.text(documentStream) : this.base64(documentStream));
    }

    private boolean canSign() {
        return this.beforeSignChecker == null || this.beforeSignChecker.check();
    }

    private String cantSignMessage() {
        return this.beforeSignChecker != null && this.beforeSignChecker.checkMessage() != null ? this.beforeSignChecker.checkMessage() : "User can't sign document";
    }

    private String base64(InputStream document) {
        try {
            if (document == null) {
                return null;
            }
            return Base64.encode((byte[])IOUtils.toByteArray(document));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private String text(InputStream document) {
        try {
            if (document == null) {
                return null;
            }
            return new String(IOUtils.toByteArray(document));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private SignDocumentBatchEntry schemaOf(io.intino.alexandria.ui.displays.components.sign.SignDocument document) {
        return new SignDocumentBatchEntry().id(document.id()).url(document.url());
    }

    public static interface DocumentProvider
    extends SignProvider {
        public InputStream document();
    }

    public static interface SignProvider {
    }

    public static interface BatchProvider
    extends SignProvider {
        public List<InputStream> documents();
    }

    public static interface BeforeSignChecker {
        public boolean check();

        default public String checkMessage() {
            return null;
        }
    }
}

