/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Resource;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractUpload;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.UploadEvent;
import io.intino.alexandria.ui.displays.events.UploadListener;
import io.intino.alexandria.ui.displays.notifiers.UploadNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Upload<DN extends UploadNotifier, B extends Box>
extends AbstractUpload<DN, B> {
    protected Listener uploadingListener = null;
    protected UploadListener executeListener = null;
    private int filesToUploadCount = 0;
    private List<Resource> files = new ArrayList<Resource>();
    private List<Type> allowedTypes;

    public Upload(B box) {
        super(box);
    }

    public Upload<DN, B> onUploading(Listener listener) {
        this.uploadingListener = listener;
        return this;
    }

    public Upload<DN, B> onExecute(UploadListener listener) {
        this.executeListener = listener;
        return this;
    }

    public Upload<DN, B> allowedTypes(List<Type> types) {
        this._allowedTypes(types);
        this.notifyAllowedTypes(types);
        return this;
    }

    public void multipleSelection(boolean value) {
        ((UploadNotifier)this.notifier).refreshMultipleSelection(value);
    }

    public void execute() {
        this.filesToUploadCount = 0;
        this.files = new ArrayList<Resource>();
        ((UploadNotifier)this.notifier).openDialog();
    }

    public void notifyUploading(int count) {
        this.filesToUploadCount = count;
        if (this.uploadingListener != null) {
            this.uploadingListener.accept(new Event(this));
        }
    }

    @Override
    public void add(Resource file) {
        this.files.add(file);
        this.notifyUploaded();
    }

    public void notifyUploaded() {
        if (this.filesToUploadCount != this.files.size()) {
            return;
        }
        if (this.executeListener == null) {
            return;
        }
        this.executeListener.accept(new UploadEvent(this, this.files));
    }

    protected Upload<DN, B> _allowedTypes(List<Type> allowedTypes) {
        this.allowedTypes = allowedTypes;
        return this;
    }

    private void notifyAllowedTypes(List<Type> types) {
        ((UploadNotifier)this.notifier).refreshAllowedTypes(types.stream().map(Enum::name).collect(Collectors.toList()));
    }

    public static enum Type {
        Image,
        Audio,
        Video,
        Application,
        Text,
        Xml,
        Html,
        Pdf,
        Excel;

    }
}

