package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseDialog;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class BaseDialogRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public BaseDialogRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		BaseDialog display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("open")) {
			display.open();
			return;
		}
		else if (operation.equals("close")) {
			display.close();
			return;
		}

		super.execute();
	}
}