package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.DateNavigator;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UIMessage;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class DateNavigatorPushRequester extends io.intino.alexandria.ui.displays.requesters.ComponentPushRequester {

	public void execute(UIClient client, UIMessage message) {
		DateNavigator display = display(client, message);
		if (display == null) return;
		String operation = operation(message);
		String data = data(message);

		if (operation.equals("first")) {
			display.first();
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}
		else if (operation.equals("last")) {
			display.last();
			return;
		}
		else if (operation.equals("select")) {
			display.select(data != null ? java.time.Instant.ofEpochMilli(Long.parseLong(data)) : null);
			return;
		}
		else if (operation.equals("changeScale")) {
			display.changeScale(data);
			return;
		}

		super.execute(client, message);
	}

}