/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.TimelineHistoryFetch;
import io.intino.alexandria.schemas.TimelineMagnitudeSorting;
import io.intino.alexandria.schemas.TimelineMagnitudeVisibility;
import io.intino.alexandria.ui.displays.components.Timeline;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.ComponentRequester;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import java.util.List;

public class TimelineRequester
extends ComponentRequester {
    public TimelineRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        Timeline display = (Timeline)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("openHistory")) {
            display.openHistory(this.manager.fromQuery("v"));
            return;
        }
        if (operation.equals("historyWithRelativeValues")) {
            display.historyWithRelativeValues((Boolean)Json.fromString((String)this.manager.fromQuery("v"), Boolean.class));
            return;
        }
        if (operation.equals("fetch")) {
            display.fetch((TimelineHistoryFetch)Json.fromString((String)this.manager.fromQuery("v"), TimelineHistoryFetch.class));
            return;
        }
        if (operation.equals("magnitudesVisibility")) {
            display.magnitudesVisibility(List.of((TimelineMagnitudeVisibility[])Json.fromString((String)this.manager.fromQuery("v"), TimelineMagnitudeVisibility[].class)));
            return;
        }
        if (operation.equals("magnitudesSorting")) {
            display.magnitudesSorting(List.of((TimelineMagnitudeSorting[])Json.fromString((String)this.manager.fromQuery("v"), TimelineMagnitudeSorting[].class)));
            return;
        }
        super.execute();
    }
}

