/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.Mark;
import io.intino.alexandria.schemas.Selected;
import io.intino.alexandria.schemas.ToolbarState;
import io.intino.alexandria.ui.displays.components.AbstractBaseSlider;
import io.intino.alexandria.ui.displays.components.slider.Animation;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.Range;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.BaseSliderNotifier;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public abstract class BaseSlider<DN extends BaseSliderNotifier, B extends Box>
extends AbstractBaseSlider<DN, B> {
    private Ordinal ordinal = null;
    private List<Ordinal> ordinalList = new ArrayList<Ordinal>();
    private Animation animation;
    private ChangeListener changeListener = null;
    private Timer playerStepTimer = null;
    private boolean readonly;
    private List<BaseSlider<DN, B>> observers = new ArrayList<BaseSlider<DN, B>>();
    private ReadonlyListener readonlyListener = null;
    protected Object value;
    protected Range range = null;

    public BaseSlider(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.refresh();
    }

    public BaseSlider onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    public BaseSlider onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    public <T> T value() {
        return (T)this.value;
    }

    public Ordinal ordinal() {
        return this.ordinal;
    }

    public void selectOrdinal(String name) {
        this.selectOrdinal(name, this.value);
    }

    @Override
    public BaseSlider add(Ordinal ordinal) {
        this._add(ordinal);
        return this;
    }

    public BaseSlider ordinal(Ordinal ordinal) {
        this.ordinal = ordinal;
        this.updateRange();
        return this;
    }

    public Range range() {
        return this.range;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public void value(Object value) {
        if (!this.checkRange(value)) {
            return;
        }
        this._value(value);
        this.notifyChange();
    }

    public void addObserver(BaseSlider slider) {
        this.observers.add(slider);
    }

    public BaseSlider<DN, B> readonly(boolean value) {
        this._readonly(value);
        this.notifyReadonly(value);
        return this;
    }

    public BaseSlider<DN, B> marks(Long ... marks) {
        return this.marks(Arrays.stream(marks).map(this::markOf).collect(Collectors.toList()));
    }

    public BaseSlider<DN, B> marks(Mark ... marks) {
        return this.marks(Arrays.stream(marks).collect(Collectors.toList()));
    }

    public BaseSlider<DN, B> marks(List<Mark> markList) {
        ((BaseSliderNotifier)this.notifier).refreshMarks(markList);
        return this;
    }

    protected Mark markOf(long value) {
        return new Mark().value(value).label(this.format(value));
    }

    public void play() {
        if (this.animation == null) {
            return;
        }
        this.playerStep();
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void pause() {
        if (this.animation == null) {
            return;
        }
        if (this.playerStepTimer == null) {
            return;
        }
        this.playerStepTimer.cancel();
        this.playerStepTimer = null;
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.notifier == null) {
            return;
        }
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        ((BaseSliderNotifier)this.notifier).refreshOrdinals(this.schemaOrdinals());
        this.refreshSelected(this.selectedValue());
        ((BaseSliderNotifier)this.notifier).refreshRange(this.rangeSchema());
        if (this.ordinal() != null) {
            ((BaseSliderNotifier)this.notifier).refreshSelectedOrdinal(this.ordinal().name());
        }
    }

    ChangeListener changeListener() {
        return this.changeListener;
    }

    void notifyChange() {
        this.notifyChange(this.value());
    }

    void notifyChange(Object value) {
        this.refreshSelected(this.schemaOf(value));
        ((BaseSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        this.notifyObservers();
        this.notifyListener();
    }

    io.intino.alexandria.schemas.Range rangeSchema() {
        return new io.intino.alexandria.schemas.Range().min(this.range().min()).max(this.range.max());
    }

    void notifyListener() {
        if (this.changeListener == null) {
            return;
        }
        this.changeListener.accept(new ChangeEvent(this, this.value));
    }

    private void notifyObservers() {
        this.observers.forEach(o -> {
            o._value(this.value());
            o.refreshSelected(this.selectedValue());
            ((BaseSliderNotifier)o.notifier).refreshToolbar(this.toolbarState());
        });
    }

    public abstract void reset();

    abstract boolean checkRange(Object var1);

    public abstract void previous();

    public abstract void next();

    abstract boolean canPrevious();

    abstract boolean canNext();

    abstract void nextValue();

    abstract <T> void _value(T var1);

    abstract void _range(long var1, long var3);

    abstract String format(long var1);

    abstract void updateRange();

    abstract <T extends Selected> void refreshSelected(T var1);

    abstract Selected schemaOf(Object var1);

    public BaseSlider _add(Ordinal ordinal) {
        this.ordinalList.add(ordinal);
        if (this.ordinal == null) {
            this.ordinal(this.ordinalList.get(this.ordinalList.size() - 1));
        }
        return this;
    }

    protected BaseSlider _animation(int interval, boolean loop) {
        this.animation = new Animation().interval(interval).loop(loop);
        return this;
    }

    protected BaseSlider _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    void selectOrdinal(String name, Object value) {
        this.ordinal(this.ordinals().stream().filter(o -> o.name().equals(name)).findFirst().orElse(null));
        ((BaseSliderNotifier)this.notifier).refreshSelectedOrdinal(name);
        this.value(value);
    }

    ToolbarState toolbarState() {
        return new ToolbarState().canPrevious(this.canPrevious()).canNext(this.canNext()).playing(this.playerStepTimer != null);
    }

    List<Ordinal> defaultOrdinals() {
        return List.of(new Ordinal(){

            @Override
            public String name() {
                return "ordinal";
            }

            @Override
            public String label() {
                return "Ordinal";
            }

            @Override
            public int step() {
                return 1;
            }

            @Override
            public Ordinal.Formatter formatter(String language) {
                return value -> NumberFormat.getNumberInstance(Locale.forLanguageTag(language)).format(value);
            }
        });
    }

    private List<io.intino.alexandria.schemas.Ordinal> schemaOrdinals() {
        return this.ordinals().stream().map(this::ordinalOf).collect(Collectors.toList());
    }

    private List<Ordinal> ordinals() {
        return this.ordinalList.isEmpty() ? this.defaultOrdinals() : this.ordinalList;
    }

    private io.intino.alexandria.schemas.Ordinal ordinalOf(Ordinal ordinal) {
        return new io.intino.alexandria.schemas.Ordinal().name(ordinal.name()).label(ordinal.label()).step(ordinal.step());
    }

    private void playerStep() {
        if (!this.canNext() && !this.canLoop()) {
            this.playerStepTimer = null;
            return;
        }
        this.nextValue();
        this.playerStepTimer = new Timer("playerStepTimer");
        this.playerStepTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                BaseSlider.this.playerStep();
                ((BaseSliderNotifier)BaseSlider.this.notifier).refreshToolbar(BaseSlider.this.toolbarState());
            }
        }, this.animation.interval);
    }

    protected boolean canLoop() {
        return this.animation != null && this.animation.loop;
    }

    private Selected selectedValue() {
        return this.schemaOf(this.value);
    }

    private void notifyReadonly(boolean value) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, value));
        }
        ((BaseSliderNotifier)this.notifier).refreshReadonly(value);
    }
}

