package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.Slider;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class SliderRequester extends BaseSliderRequester {

	public SliderRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		Slider display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("moved")) {
			display.moved(Long.parseLong(manager.fromQuery("v")));
			return;
		}
		else if (operation.equals("update")) {
			display.update(Long.parseLong(manager.fromQuery("v")));
			return;
		}

		super.execute();
	}
}