/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractTextEditableCode;
import io.intino.alexandria.ui.displays.components.editable.Editable;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.events.ChangeListener;
import io.intino.alexandria.ui.displays.events.ReadonlyEvent;
import io.intino.alexandria.ui.displays.events.ReadonlyListener;
import io.intino.alexandria.ui.displays.notifiers.TextEditableCodeNotifier;

public class TextEditableCode<DN extends TextEditableCodeNotifier, B extends Box>
extends AbstractTextEditableCode<DN, B>
implements Editable<DN, B> {
    private boolean readonly;
    private ChangeListener changeListener = null;
    private ReadonlyListener readonlyListener = null;

    public TextEditableCode(B box) {
        super(box);
    }

    @Override
    public TextEditableCode<DN, B> onChange(ChangeListener listener) {
        this.changeListener = listener;
        return this;
    }

    @Override
    public void reload() {
        ((TextEditableCodeNotifier)this.notifier).refresh(this.value());
    }

    @Override
    public boolean readonly() {
        return this.readonly;
    }

    @Override
    public TextEditableCode<DN, B> onReadonly(ReadonlyListener listener) {
        this.readonlyListener = listener;
        return this;
    }

    @Override
    public TextEditableCode<DN, B> focus() {
        ((TextEditableCodeNotifier)this.notifier).refreshFocused(true);
        return this;
    }

    public void update(String value) {
        if (!this.notifyChange(value)) {
            return;
        }
        super.value(value);
    }

    public boolean notifyChange(String value) {
        this._value(value != null ? value.replaceAll("&plus;", "+") : null);
        if (this.changeListener != null) {
            this.changeListener.accept(new ChangeEvent(this, this.value()));
        }
        return true;
    }

    @Override
    public TextEditableCode<DN, B> readonly(boolean readonly) {
        this._readonly(readonly);
        this.notifyReadonly(readonly);
        return this;
    }

    @Override
    protected TextEditableCode<DN, B> _value(String value) {
        super._value(value != null ? value.replaceAll("&#13;", "\n") : null);
        return this;
    }

    protected TextEditableCode<DN, B> _readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    private void notifyReadonly(boolean value) {
        if (this.readonlyListener != null) {
            this.readonlyListener.accept(new ReadonlyEvent(this, value));
        }
        ((TextEditableCodeNotifier)this.notifier).refreshReadonly(value);
    }
}

