package io.intino.alexandria.schemas;

import io.intino.alexandria.schemas.*;

public class ChatMessage implements java.io.Serializable {

	private java.time.Instant date;
	private String content;
	private Boolean active = false;
	private Direction direction;

	public enum Direction {
		Incoming, Outgoing
	}

	private java.util.List<Attachment> attachments = new java.util.ArrayList<>();

	public java.time.Instant date() {
		return this.date;
	}

	public String content() {
		return this.content;
	}

	public Boolean active() {
		return this.active;
	}

	public Direction direction() {
		return direction;
	}

	public java.util.List<Attachment> attachments() {
		return this.attachments;
	}

	public ChatMessage date(java.time.Instant date) {
		this.date = date;
		return this;
	}

	public ChatMessage content(String content) {
		this.content = content;
		return this;
	}

	public ChatMessage active(Boolean active) {
		this.active = active;
		return this;
	}

	public ChatMessage direction(Direction direction) {
		this.direction = direction;
		return this;
	}

	public ChatMessage attachments(java.util.List<Attachment> attachments) {
		this.attachments = attachments;
		return this;
	}
}