/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.events;

import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.icod.core.SignatureInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SignEvent
extends Event {
    private final List<SignEventInfo> infoList;

    public SignEvent(Display sender, String signature, String certificate, SignatureInfo info) {
        super(sender);
        this.infoList = Collections.singletonList(new SignEventInfo(null, signature, certificate, info));
    }

    public SignEvent(Display sender, List<SignEventInfo> infoList) {
        super(sender);
        this.infoList = infoList;
    }

    public String signature() {
        return this.infoList.get((int)0).signature;
    }

    public String certificate() {
        return this.infoList.get((int)0).certificate;
    }

    public SignatureInfo info() {
        return this.infoList.get((int)0).info;
    }

    public Map<String, String> signatures() {
        return this.infoList.stream().collect(Collectors.toMap(i -> i.id, i -> i.signature));
    }

    public Map<String, String> signaturesCertificate() {
        return this.infoList.stream().collect(Collectors.toMap(i -> i.id, i -> i.certificate));
    }

    public Map<String, SignatureInfo> signaturesInfo() {
        return this.infoList.stream().collect(Collectors.toMap(i -> i.id, i -> i.info));
    }

    public static class SignEventInfo {
        public String id;
        public String signature;
        public String certificate;
        public SignatureInfo info;

        public SignEventInfo(String id, String signature, String certificate, SignatureInfo info) {
            this.id = id;
            this.signature = signature;
            this.certificate = certificate;
            this.info = info;
        }
    }
}

