/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.collection;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.model.datasource.filters.RangeFilter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CollectionAddressResolver {
    public static final String Condition = "c";
    public static final String Filters = "f";
    public static final String Sortings = "s";

    public static String queryString(Collection<?, ?> collection, String grouping, List<String> groups) {
        if (collection == null) {
            return null;
        }
        return CollectionAddressResolver.serialize(CollectionAddressResolver.parameters(collection, grouping, groups));
    }

    private static Map<String, String> parameters(Collection<?, ?> collection, String grouping, List<String> groups) {
        List<String> filters;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (collection.condition() != null) {
            result.put(Condition, collection.condition());
        }
        if ((filters = CollectionAddressResolver.filters(collection.filters(), grouping, groups)).size() > 0) {
            result.put(Filters, CollectionAddressResolver.serialize(filters));
        }
        if (collection.sortings().size() > 0) {
            result.put(Sortings, String.join((CharSequence)",", collection.sortings()));
        }
        return result;
    }

    private static String serialize(List<String> filters) {
        return String.join((CharSequence)";", filters);
    }

    private static String serialize(Map<String, String> parameters) {
        return parameters.entrySet().stream().map(p -> (String)p.getKey() + "=" + URLEncoder.encode((String)p.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    private static String serialize(Filter filter) {
        return String.join((CharSequence)",", CollectionAddressResolver.values(filter));
    }

    private static List<String> filters(List<Filter> filterList, String grouping, List<String> groups) {
        Map<String, String> result = filterList.stream().collect(Collectors.toMap(Filter::grouping, CollectionAddressResolver::serialize));
        if (grouping != null) {
            result.put(grouping, String.join((CharSequence)",", groups));
        }
        return result.entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).map(f -> (String)f.getKey() + "#" + (String)f.getValue()).collect(Collectors.toList());
    }

    private static Set<String> values(Filter filter) {
        if (filter instanceof GroupFilter) {
            return ((GroupFilter)filter).groups();
        }
        if (filter instanceof RangeFilter) {
            return Set.of(new Timetag(((RangeFilter)filter).from(), Scale.Minute).value(), new Timetag(((RangeFilter)filter).to(), Scale.Minute).value());
        }
        return Collections.emptySet();
    }
}

