package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.HtmlViewer;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class HtmlViewerRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public HtmlViewerRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		HtmlViewer display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("execute")) {
			display.execute(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), io.intino.alexandria.schemas.HtmlViewerOperation.class));
			return;
		}

		super.execute();
	}
}