package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BaseSlider;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class BaseSliderRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public BaseSliderRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		BaseSlider display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("selectOrdinal")) {
			display.selectOrdinal(manager.fromQuery("v"));
			return;
		}
		else if (operation.equals("play")) {
			display.play();
			return;
		}
		else if (operation.equals("pause")) {
			display.pause();
			return;
		}
		else if (operation.equals("previous")) {
			display.previous();
			return;
		}
		else if (operation.equals("next")) {
			display.next();
			return;
		}

		super.execute();
	}
}