/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.components.AbstractLibraryTemplateStamp;
import io.intino.alexandria.ui.displays.notifiers.LibraryTemplateStampNotifier;
import io.intino.alexandria.ui.services.push.UIClient;
import java.util.HashMap;
import java.util.Map;

public abstract class LibraryTemplateStamp<DN extends LibraryTemplateStampNotifier, B extends Box>
extends AbstractLibraryTemplateStamp<B> {
    private String template;
    private String path;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private static final String Url = "%s/%s%ssession=%s&client=%s&token=%s";

    public LibraryTemplateStamp(B box) {
        super(box);
    }

    public String template() {
        return this.template;
    }

    public LibraryTemplateStamp<DN, B> template(String value) {
        return this._template(value);
    }

    public LibraryTemplateStamp<DN, B> path(String path) {
        return this._path(path);
    }

    @Override
    public LibraryTemplateStamp<DN, B> add(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    protected LibraryTemplateStamp<DN, B> _template(String value) {
        this.template = value;
        return this;
    }

    protected LibraryTemplateStamp<DN, B> _path(String value) {
        this.path = value;
        return this;
    }

    public boolean existsTemplate(String name) {
        return name != null;
    }

    public boolean existsTemplate() {
        return this.existsTemplate(this.template);
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.template == null) {
            this.notifyUser(this.translate("Template type must be defined"), UserMessage.Type.Error);
            return;
        }
        if (this.path == null) {
            this.notifyUser(this.translate("Template path must be defined"), UserMessage.Type.Error);
            return;
        }
        if (!this.existsTemplate()) {
            this.notifyUser(this.translate("Template not found in library"), UserMessage.Type.Error);
            return;
        }
        ((LibraryTemplateStampNotifier)this.notifier).refresh(this.url());
    }

    private String url() {
        String token = ((UIClient)this.session().client()).id();
        StringBuilder result = new StringBuilder();
        result.append(String.format(Url, this.session().browser().baseUrl(), this.path.replace(":template", this.template.toLowerCase()), this.path.contains("?") ? "&" : "?", this.session().id(), ((UIClient)this.session().client()).id(), token));
        this.parameters.forEach((key, value) -> result.append("&").append((String)key).append("=").append((String)value));
        return result.toString();
    }
}

