/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.RangeSelected;
import io.intino.alexandria.schemas.RangeValue;
import io.intino.alexandria.schemas.Selected;
import io.intino.alexandria.ui.displays.components.AbstractRangeSlider;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.Range;
import io.intino.alexandria.ui.displays.notifiers.RangeSliderNotifier;

public class RangeSlider<DN extends RangeSliderNotifier, B extends Box>
extends AbstractRangeSlider<DN, B> {
    public RangeSlider(B box) {
        super(box);
        this._value(0L, 0L);
    }

    @Override
    public void reset() {
        Range range = this.range();
        this._value(range.min(), range.max());
    }

    protected RangeSlider<DN, B> _value(long from, long to) {
        return this._value(new RangeValue().from(from).to(to));
    }

    protected RangeSlider<DN, B> _value(RangeValue value) {
        this.value = value;
        return this;
    }

    public RangeSlider<DN, B> range(long min, long max) {
        this._range(min, max);
        ((RangeSliderNotifier)this.notifier).refreshRange(this.rangeSchema());
        return this;
    }

    public String formattedValue(long value) {
        return this.format(value);
    }

    public void moved(RangeValue value) {
        ((RangeSliderNotifier)this.notifier).refreshSelected(this.schemaOf(value));
        ((RangeSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
    }

    public void update(RangeValue value) {
        this.value(value);
    }

    @Override
    String format(long value) {
        Ordinal ordinal = this.ordinal();
        if (ordinal == null) {
            ordinal = this.defaultOrdinals().get(0);
        }
        return ordinal != null ? ordinal.formatter(this.language()).format(value) : String.valueOf(value);
    }

    @Override
    void updateRange() {
    }

    @Override
    <T extends Selected> void refreshSelected(T schema) {
        ((RangeSliderNotifier)this.notifier).refreshSelected((RangeSelected)schema);
    }

    @Override
    protected void _value(Object value) {
        this.value = value;
    }

    @Override
    protected void _range(long min, long max) {
        this.range = new Range().min(min).max(max);
        RangeValue value = (RangeValue)this.value();
        if (value.from() < min) {
            value.from(min);
        }
        if (value.to() < min) {
            value.to(min);
        }
        if (value.from() > max) {
            value.from(max);
        }
        if (value.to() > max) {
            value.to(max);
        }
        this._value(value);
    }

    @Override
    public void previous() {
        RangeValue values = (RangeValue)this.value;
        values.from(values.from() - 1L);
        values.to(values.to() - 1L);
        this.value(values);
    }

    @Override
    public void next() {
        RangeValue values = (RangeValue)this.value;
        values.from(values.from() + 1L);
        values.to(values.to() + 1L);
        this.value(values);
    }

    @Override
    protected boolean canPrevious() {
        return ((RangeValue)this.value()).from() > this.range.min;
    }

    @Override
    protected boolean canNext() {
        return ((RangeValue)this.value()).to() < this.range.max;
    }

    @Override
    protected void nextValue() {
        RangeValue value = (RangeValue)this.value();
        if (value.to() >= this.range.max) {
            if (this.canLoop()) {
                value.to(value.to() - value.from() - 1L);
                value.from(this.range.min() - 1L);
                this.value(value);
            } else {
                return;
            }
        }
        value.from(value.from() + 1L);
        value.to(value.to() + 1L);
        this.value(value);
    }

    @Override
    protected boolean checkRange(Object value) {
        RangeValue values = (RangeValue)value;
        if (values.to() > this.range.max) {
            return false;
        }
        return values.from() >= this.range.min;
    }

    @Override
    protected RangeSelected schemaOf(Object value) {
        RangeValue values = (RangeValue)value;
        String formattedFrom = this.formattedValue(values.from());
        String formattedTo = this.formattedValue(values.to());
        return (RangeSelected)new RangeSelected().to(values.to()).formattedTo(formattedTo).value(values.from()).formattedValue(formattedFrom);
    }
}

