package io.intino.alexandria;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

import java.util.HashMap;
import java.util.Map;

import io.intino.alexandria.logger.Logger;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryArchetype;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryInstaller;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryLoader;
import io.intino.alexandria.ui.services.libraries.AlexandriaLibraryUiInitializer;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.Soul;

public abstract class AbstractBox extends io.intino.alexandria.ui.AlexandriaUiBox {
	protected UiFrameworkConfiguration configuration;
	protected Map<String, Soul> uiSouls = new java.util.HashMap<>();
	protected java.util.List<AlexandriaLibraryLoader> libraryLoaders = new java.util.ArrayList<>();;
	private java.util.List<io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new java.util.ArrayList<>();
	private io.intino.alexandria.ui.services.AuthService authService;

	public AbstractBox(String[] args) {
		this(new UiFrameworkConfiguration(args));
	}

	public AbstractBox(UiFrameworkConfiguration configuration) {
		this.configuration = configuration;
		initJavaLogger();
	}

	public UiFrameworkConfiguration configuration() {
		return configuration;
	}

	@Override
	public io.intino.alexandria.core.Box put(Object o) {
		super.put(o);
		return this;
	}

	public abstract void beforeStart();

	public io.intino.alexandria.core.Box start() {
		initConnector();
		if (owner != null) owner.beforeStart();
		beforeStart();
		if (owner != null) owner.startServices();
		startServices();
		if (owner != null) owner.afterStart();
		afterStart();
		return this;
	}

	public abstract void afterStart();

	public abstract void beforeStop();

	public void stop() {
		if (owner != null) owner.beforeStop();
		beforeStop();
		if (owner != null) owner.stopServices();
		stopServices();
		if (owner != null) owner.afterStop();
		afterStop();
	}

	@Override
	public void stopServices() {
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.instance().stop();
	}

	public abstract void afterStop();

	@Override
	public void startServices() {
		initUI();
		initAgenda();
		initRestServices();
		initSoapServices();
		initJmxServices();
		initTerminal();
		initMessagingServices();
		initSentinels();
		initSlackBots();
		initWorkflow();
		initCli();
	}

	public java.util.List<Soul> souls() {
		return new java.util.ArrayList<>(uiSouls.values());
	}

	public java.util.Optional<Soul> soul(String clientId) {
		return java.util.Optional.ofNullable(uiSouls.get(clientId));
	}

	public void registerSoul(String clientId, Soul soul) {
		uiSouls.put(clientId, soul);
	}

	public void unRegisterSoul(String clientId) {
		uiSouls.remove(clientId);
		if (uiSouls.size() <= 0) notifySoulsClosed();
	}

	public void onSoulsClosed(io.intino.alexandria.ui.AlexandriaUiBox.SoulsClosed listener) {
		this.soulsClosedListeners.add(listener);
	}

	private void notifySoulsClosed() {
		soulsClosedListeners.forEach(l -> l.accept());
	}

	public boolean existsLibraryTemplate(String name) {
		return libraryLoaders.stream().anyMatch(l -> l.libraryTemplateEntryPointClass(name) != null);
	}

	protected abstract io.intino.alexandria.ui.services.AuthService authService(java.net.URL authServiceUrl);

	protected void beforeSetupUiElementsUi(io.intino.alexandria.ui.AlexandriaUiServer server) {}
	public void setupUiElementsUi() {
		if("9000" == null || "9000".isEmpty()) return;
		this.authService = null;
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.setup(Integer.parseInt("9000"), "www/", Long.parseLong("1048576"));
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.setUI(true);
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.addParameters(this.authService);
		this.pushService = owner != null && owner instanceof io.intino.alexandria.ui.AlexandriaUiBox ? ((io.intino.alexandria.ui.AlexandriaUiBox)owner).pushService() : new io.intino.alexandria.ui.services.push.PushService();
		io.intino.alexandria.ui.AlexandriaUiServer server = (io.intino.alexandria.ui.AlexandriaUiServer) io.intino.alexandria.http.AlexandriaHttpServerBuilder.instance();
		beforeSetupUiElementsUi(server);
		io.intino.alexandria.ui.UiElementsService.init(server, (UiFrameworkBox) this, pushService, new io.intino.alexandria.ui.displays.RouteDispatcher());


		io.intino.alexandria.ui.UiElementsService.initDisplays(server, pushService);
	}

	protected void beforeSetupUiMobileUi(io.intino.alexandria.ui.AlexandriaUiServer server) {}
	public void setupUiMobileUi() {
		if("9000" == null || "9000".isEmpty()) return;
		this.authService = null;
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.setup(Integer.parseInt("9000"), "www/", Long.parseLong("104857600"));
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.setUI(true);
		io.intino.alexandria.http.AlexandriaHttpServerBuilder.addParameters(this.authService);
		this.pushService = owner != null && owner instanceof io.intino.alexandria.ui.AlexandriaUiBox ? ((io.intino.alexandria.ui.AlexandriaUiBox)owner).pushService() : new io.intino.alexandria.ui.services.push.PushService();
		io.intino.alexandria.ui.AlexandriaUiServer server = (io.intino.alexandria.ui.AlexandriaUiServer) io.intino.alexandria.http.AlexandriaHttpServerBuilder.instance();
		beforeSetupUiMobileUi(server);
		io.intino.alexandria.ui.UiMobileService.init(server, (UiFrameworkBox) this, pushService, new io.intino.alexandria.ui.displays.RouteDispatcher());


		io.intino.alexandria.ui.UiElementsService.initDisplays(server, pushService);
	}

	private void initRestServices() {

	}

	private void initSoapServices() {

	}

	private void initMessagingServices() {

	}

	private void initJmxServices() {

	}

	private void initSlackBots() {

	}

	private void initUI() {
		setupUiElementsUi();
		this.initTranslatorService();
		io.intino.alexandria.ui.AlexandriaUiServer serverUiElementsInstance = (io.intino.alexandria.ui.AlexandriaUiServer) io.intino.alexandria.http.AlexandriaHttpServerBuilder.instance();
		serverUiElementsInstance.start();
		Logger.info("UI UiElements: started at port " + "9000" + "!");
		setupUiMobileUi();
		this.initTranslatorService();
		io.intino.alexandria.ui.AlexandriaUiServer serverUiMobileInstance = (io.intino.alexandria.ui.AlexandriaUiServer) io.intino.alexandria.http.AlexandriaHttpServerBuilder.instance();
		serverUiMobileInstance.start();
		Logger.info("UI UiMobile: started at port " + "9000" + "!");
	}

	private void initTranslatorService() {
		translatorService = new io.intino.alexandria.ui.services.TranslatorService();

		translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
		translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
	}

	protected void initConnector() {
	}

	protected void initTerminal() {
	}

	protected void initSentinels() {
	}

	protected void initWorkflow() {
	}

	protected void initAgenda() {

	}

	protected void initCli() {

	}

	protected void initJavaLogger() {
		final java.util.logging.Logger Logger = java.util.logging.Logger.getGlobal();
		final ConsoleHandler handler = new ConsoleHandler();
		handler.setLevel(Level.INFO);
		handler.setFormatter(new io.intino.alexandria.logger.Formatter());
		Logger.setUseParentHandlers(false);
		Logger.addHandler(handler);
		io.intino.alexandria.logger4j.Logger.init();
	}

	public static java.net.URL url(String url) {
        try {
            return new java.net.URI(url).toURL();
        } catch (java.net.MalformedURLException | java.net.URISyntaxException | IllegalArgumentException e) {
            return null;
        }
    }
}