/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.templates;

import io.intino.alexandria.Resource;
import io.intino.alexandria.UiFrameworkBox;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.displays.components.Chat;
import io.intino.alexandria.ui.displays.templates.AbstractChatExamplesMold;
import io.intino.alexandria.ui.model.chat.ChatDatasource;
import io.intino.alexandria.ui.model.chat.Message;
import io.intino.alexandria.ui.model.chat.MessageReader;
import io.intino.alexandria.ui.model.chat.buckets.BucketMessageReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public class ChatExamplesMold
extends AbstractChatExamplesMold<UiFrameworkBox> {
    public ChatExamplesMold(UiFrameworkBox box) {
        super(box);
    }

    @Override
    public void init() {
        super.init();
        this.init(this.chat1, false);
        this.init(this.chat2, false);
        this.init(this.chat3, false);
        this.init(this.chat4, true);
    }

    private void init(Chat<?, ?> chat, boolean delayed) {
        chat.source(this.chatDatasource(delayed));
        chat.refresh();
    }

    private ChatDatasource chatDatasource(final boolean delayed) {
        final File chatStore = new File("/tmp/chat1");
        final File attachmentsDir = new File(chatStore, "attachments");
        if (!chatStore.exists()) {
            chatStore.mkdirs();
        }
        if (!attachmentsDir.exists()) {
            attachmentsDir.mkdirs();
        }
        return new ChatDatasource(){

            @Override
            public MessageReader messages() {
                return new BucketMessageReader(chatStore);
            }

            @Override
            public void send(String message, ChatDatasource.ResponseReceiver receiver) {
                if (delayed) {
                    this.sendDelayed(message, receiver);
                } else {
                    this.sendAll(message, receiver);
                }
            }

            @Override
            public void send(String message, List<Resource> attachments, ChatDatasource.ResponseReceiver receiver) {
                attachments.forEach(this::save);
                if (delayed) {
                    this.sendDelayed(message, receiver);
                } else {
                    this.sendAll(message, receiver);
                }
            }

            private void save(Resource resource) {
                try {
                    Files.write(new File(attachmentsDir, resource.name()).toPath(), resource.bytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                }
            }

            @Override
            public URL attachmentUrl(Message message, String name) {
                try {
                    return new File(attachmentsDir, name).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    Logger.error((Throwable)e);
                    return null;
                }
            }

            private void sendAll(String message, ChatDatasource.ResponseReceiver receiver) {
                receiver.create("Message received: " + message).end();
            }

            private void sendDelayed(String message, ChatDatasource.ResponseReceiver receiver) {
                ChatDatasource.ResponseReceiver.MessageBuffer buffer = receiver.create("");
                this.schedule(e1 -> {
                    buffer.add("Message");
                    this.schedule(e2 -> {
                        buffer.add(" received");
                        this.schedule(e3 -> {
                            buffer.add(": ");
                            this.schedule(e4 -> {
                                buffer.add("**" + message + "**");
                                this.schedule(e5 -> buffer.end());
                            });
                        });
                    });
                });
            }

            private void schedule(final Consumer<Boolean> consumer) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        consumer.accept(true);
                    }
                }, 700L);
            }
        };
    }
}

