/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DialogSize;
import io.intino.alexandria.ui.displays.components.AbstractBaseDialog;
import io.intino.alexandria.ui.displays.events.BeforeListener;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.notifiers.BaseDialogNotifier;
import java.util.ArrayList;
import java.util.List;

public class BaseDialog<DN extends BaseDialogNotifier, B extends Box>
extends AbstractBaseDialog<DN, B> {
    private String title;
    private DialogSize size;
    private List<BeforeListener> beforeOpenListeners = new ArrayList<BeforeListener>();
    private List<Listener> openListeners = new ArrayList<Listener>();
    private List<Listener> closeListeners = new ArrayList<Listener>();

    public BaseDialog(B box) {
        super(box);
    }

    public BaseDialog<DN, B> onBeforeOpen(BeforeListener listener) {
        this.beforeOpenListeners.add(listener);
        return this;
    }

    public BaseDialog<DN, B> onOpen(Listener listener) {
        this.openListeners.add(listener);
        return this;
    }

    public BaseDialog<DN, B> onClose(Listener listener) {
        this.closeListeners.add(listener);
        return this;
    }

    public void open() {
        if (!this.notifyBeforeOpen()) {
            return;
        }
        ((BaseDialogNotifier)this.notifier).open();
        this.notifyOpen();
    }

    public void close() {
        ((BaseDialogNotifier)this.notifier).close();
        this.notifyClose();
    }

    public BaseDialog<DN, B> title(String title) {
        this._title(title);
        ((BaseDialogNotifier)this.notifier).refreshTitle(title);
        return this;
    }

    public BaseDialog<DN, B> relativeWidth(int width) {
        return this.relativeSize(width, 100);
    }

    public BaseDialog<DN, B> relativeHeight(int height) {
        return this.relativeSize(100, height);
    }

    public BaseDialog<DN, B> relativeSize(int width, int height) {
        if (width > 100) {
            width = 100;
        }
        if (height > 100) {
            height = 100;
        }
        return this.size(width + "%", height + "%");
    }

    public BaseDialog<DN, B> absoluteWidth(int width) {
        return this.size(width + "px", "100%");
    }

    public BaseDialog<DN, B> absoluteHeight(int height) {
        return this.size("100%", height + "px");
    }

    public BaseDialog<DN, B> absoluteSize(int width, int height) {
        return this.size(width + "px", height + "px");
    }

    public BaseDialog<DN, B> size(String width, String height) {
        this._size(new DialogSize().width(width).height(height));
        ((BaseDialogNotifier)this.notifier).refreshSize(this.size);
        return this;
    }

    protected BaseDialog<DN, B> _title(String title) {
        this.title = title;
        return this;
    }

    protected BaseDialog<DN, B> _size(DialogSize size) {
        this.size = size;
        return this;
    }

    private boolean notifyBeforeOpen() {
        return this.beforeOpenListeners.stream().allMatch(l -> l.accept(new Event(this)));
    }

    private void notifyOpen() {
        this.openListeners.forEach(l -> l.accept(new Event(this)));
    }

    private void notifyClose() {
        this.closeListeners.forEach(l -> l.accept(new Event(this)));
    }
}

