/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.schemas.EventlineExecuteEventParams;
import io.intino.alexandria.schemas.EventlineSelectEventParams;
import io.intino.alexandria.ui.displays.components.Eventline;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.ComponentRequester;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import java.time.Instant;
import java.util.List;

public class EventlineRequester
extends ComponentRequester {
    public EventlineRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        Eventline display = (Eventline)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("update")) {
            display.update(this.manager.fromQuery("v") != null ? Instant.ofEpochMilli(Long.parseLong(this.manager.fromQuery("v"))) : null);
            return;
        }
        if (operation.equals("first")) {
            display.first();
            return;
        }
        if (operation.equals("previous")) {
            display.previous();
            return;
        }
        if (operation.equals("previousPage")) {
            display.previousPage();
            return;
        }
        if (operation.equals("next")) {
            display.next();
            return;
        }
        if (operation.equals("nextPage")) {
            display.nextPage();
            return;
        }
        if (operation.equals("last")) {
            display.last();
            return;
        }
        if (operation.equals("page")) {
            display.page(Integer.parseInt(this.manager.fromQuery("v")));
            return;
        }
        if (operation.equals("selectEvent")) {
            display.selectEvent((EventlineSelectEventParams)Json.fromString((String)this.manager.fromQuery("v"), EventlineSelectEventParams.class));
            return;
        }
        if (operation.equals("selectEvents")) {
            display.selectEvents(List.of((EventlineSelectEventParams[])Json.fromString((String)this.manager.fromQuery("v"), EventlineSelectEventParams[].class)));
            return;
        }
        if (operation.equals("executeEvent")) {
            display.executeEvent((EventlineExecuteEventParams)Json.fromString((String)this.manager.fromQuery("v"), EventlineExecuteEventParams.class));
            return;
        }
        super.execute();
    }
}

